/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresql.PGResultSetMetaData;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.Field;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2ResultSetMetaData
implements PGResultSetMetaData {
    protected final BaseConnection connection;
    protected final Field[] fields;
    private Hashtable tableNameCache;
    private Hashtable schemaNameCache;

    public AbstractJdbc2ResultSetMetaData(BaseConnection connection, Field[] fields) {
        this.connection = connection;
        this.fields = fields;
    }

    public String getBaseColumnName(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getColumnName(this.connection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getBaseSchemaName(int column) throws SQLException {
        String string;
        PreparedStatement ps;
        block7: {
            String schemaName;
            Field field = this.getField(column);
            if (field.getTableOid() == 0) {
                return "";
            }
            Integer tableOid = new Integer(field.getTableOid());
            if (this.schemaNameCache == null) {
                this.schemaNameCache = new Hashtable();
            }
            if ((schemaName = (String)this.schemaNameCache.get(tableOid)) != null) {
                return schemaName;
            }
            ResultSet res = null;
            ps = null;
            try {
                String sql = "SELECT n.nspname FROM pg_catalog.pg_class c, pg_catalog.pg_namespace n WHERE n.oid = c.relnamespace AND c.oid = ?;";
                ps = this.connection.prepareStatement(sql);
                ps.setInt(1, tableOid);
                res = ps.executeQuery();
                schemaName = "";
                if (res.next()) {
                    schemaName = res.getString(1);
                }
                this.schemaNameCache.put(tableOid, schemaName);
                string = schemaName;
                Object var9_9 = null;
                if (res == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (res != null) {
                    res.close();
                }
                if (ps == null) throw throwable;
                ps.close();
                throw throwable;
            }
            res.close();
        }
        if (ps == null) return string;
        ps.close();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getBaseTableName(int column) throws SQLException {
        String string;
        PreparedStatement ps;
        block7: {
            String tableName;
            Field field = this.getField(column);
            if (field.getTableOid() == 0) {
                return "";
            }
            Integer tableOid = new Integer(field.getTableOid());
            if (this.tableNameCache == null) {
                this.tableNameCache = new Hashtable();
            }
            if ((tableName = (String)this.tableNameCache.get(tableOid)) != null) {
                return tableName;
            }
            ResultSet res = null;
            ps = null;
            try {
                ps = this.connection.prepareStatement("SELECT relname FROM pg_catalog.pg_class WHERE oid = ?");
                ps.setInt(1, tableOid);
                res = ps.executeQuery();
                tableName = "";
                if (res.next()) {
                    tableName = res.getString(1);
                }
                this.tableNameCache.put(tableOid, tableName);
                string = tableName;
                Object var9_8 = null;
                if (res == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (res != null) {
                    res.close();
                }
                if (ps == null) throw throwable;
                ps.close();
                throw throwable;
            }
            res.close();
        }
        if (ps == null) return string;
        ps.close();
        return string;
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public String getColumnClassName(int column) throws SQLException {
        Field field = this.getField(column);
        int sql_type = this.getSQLType(column);
        switch (sql_type) {
            case -7: {
                return "java.lang.Boolean";
            }
            case 5: {
                return "java.lang.Short";
            }
            case 4: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 8: {
                return "java.lang.Double";
            }
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -3: 
            case -2: {
                return "[B";
            }
            case 2003: {
                return "java.sql.Array";
            }
        }
        String type = this.getPGType(column);
        if ("unknown".equals(type)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        int secondSize;
        Field f = this.getField(column);
        String type_name = this.getPGType(column);
        int typmod = f.getMod();
        if (type_name.equals("int2")) {
            return 6;
        }
        if (type_name.equals("int4") || type_name.equals("oid")) {
            return 11;
        }
        if (type_name.equals("int8")) {
            return 20;
        }
        if (type_name.equals("money")) {
            return 12;
        }
        if (type_name.equals("float4")) {
            return 11;
        }
        if (type_name.equals("float8")) {
            return 20;
        }
        if (type_name.equals("char")) {
            return 1;
        }
        if (type_name.equals("bool")) {
            return 1;
        }
        switch (typmod) {
            case 0: {
                secondSize = 0;
                break;
            }
            case -1: {
                secondSize = 7;
                break;
            }
            default: {
                secondSize = typmod + typmod % 2 + 1;
            }
        }
        if (type_name.equals("date")) {
            return 13;
        }
        if (type_name.equals("time")) {
            return 8 + secondSize;
        }
        if (type_name.equals("timetz")) {
            return 8 + secondSize + 6;
        }
        if (type_name.equals("timestamp")) {
            return 19 + secondSize;
        }
        if (type_name.equals("timestamptz")) {
            return 19 + secondSize + 6;
        }
        typmod -= 4;
        if (type_name.equals("bpchar") || type_name.equals("varchar")) {
            return typmod;
        }
        if (type_name.equals("numeric")) {
            return (typmod >> 16 & 0xFFFF) + 1 + (typmod & 0xFFFF);
        }
        return f.getLength();
    }

    public String getColumnLabel(int column) throws SQLException {
        Field f = this.getField(column);
        if (f != null) {
            return f.getColumnLabel();
        }
        return "field" + column;
    }

    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    public int getColumnType(int column) throws SQLException {
        return this.getSQLType(column);
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.getPGType(column);
    }

    protected Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[columnIndex - 1];
    }

    protected String getPGType(int columnIndex) throws SQLException {
        return this.connection.getPGType(this.getField(columnIndex).getOID());
    }

    public int getPrecision(int column) throws SQLException {
        int sql_type = this.getSQLType(column);
        switch (sql_type) {
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field f = this.getField(column);
                if (f != null) {
                    if (f.getMod() == -1) {
                        return -1;
                    }
                    return (0xFFFF0000 & f.getMod()) >> 16;
                }
                return 0;
            }
        }
        return 0;
    }

    protected int getSQLType(int columnIndex) throws SQLException {
        return this.connection.getSQLType(this.getField(columnIndex).getOID());
    }

    public int getScale(int column) throws SQLException {
        int sql_type = this.getSQLType(column);
        switch (sql_type) {
            case 5: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field f = this.getField(column);
                if (f != null) {
                    if (f.getMod() == -1) {
                        return -1;
                    }
                    return (0xFFFF & f.getMod()) - 4;
                }
                return 0;
            }
            case 92: 
            case 93: {
                int typmod = -1;
                Field fld = this.getField(column);
                if (fld != null) {
                    typmod = fld.getMod();
                }
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
        }
        return 0;
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getAutoIncrement(this.connection);
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        int sql_type = this.getSQLType(column);
        switch (sql_type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        String type_name = this.getPGType(column);
        return type_name.equals("cash") || type_name.equals("money");
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public int isNullable(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getNullable(this.connection);
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public boolean isSearchable(int column) throws SQLException {
        int sql_type = this.getSQLType(column);
        switch (sql_type) {
            case 1111: {
                return true;
            }
        }
        return true;
    }

    public boolean isSigned(int column) throws SQLException {
        int sql_type = this.getSQLType(column);
        switch (sql_type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return this.isReadOnly(column) ^ true;
    }
}

