package bibliophilia;

import java.net.*;
import java.util.*;
import java.io.*;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.SAXException;

public class AmazonSearch {
    int count = 0;
    public AmazonSearch(){
    }
    public int getLastFound(){
        return count;
    }
    public Book[] find(String url) throws Exception{
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(url);
        System.out.println(url);
        
        NodeList items = document.getElementsByTagName("Item");
        Element root = document.getDocumentElement();
        if (null == getText(root, "TotalResults")){
            System.out.println("No results");
            return new Book[0];
        }
        count = Integer.parseInt(getText(root, "TotalResults"));

        Vector<Book> v = new Vector<Book>();
        for(int i = 0; i<items.getLength(); i++){
            Node node = items.item(i);
            String[] images = new String[3];
            images[0] = getText(getFirstElement(node, "SmallImage"), "URL");
            images[1] = getText(getFirstElement(node, "MediumImage"), "URL");
            images[2] = getText(getFirstElement(node, "LargeImage"), "URL");
            String manuf = getText(node, "Manufacturer");
            String binding = getText(node, "Binding");
            String title = getText(node, "Title");
            String asin = getText(node, "ASIN");
            if(getText(node, "ProductGroup") == null || !getText(node, "ProductGroup").equals("Book")){
                continue;
            }
            v.add(new Book(images, asin, manuf, binding, title));
        }
        Book[] books = (Book[])v.toArray(new Book[v.size()]);

        return books;
    }
    public static String getText(Node node, String tagName){
        if(node == null){
            return null;
        }
        Element el = (Element)node;
        NodeList list = el.getElementsByTagName(tagName);
        if(list.getLength() == 0){
            return null;
        }
        return ((Element)list.item(0)).getTextContent();
    }
    public static Element getFirstElement(Node node, String tagName){
        NodeList list = ((Element)node).getElementsByTagName(tagName);
        if(list.getLength() > 0){
            return (Element)list.item(0);
        }
        return null;
    }
    public static void main(String[] argv){
        
    }
}

