package filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LocalAccessFilter implements Filter {

    private FilterConfig config = null;
    private String[] allow_ip = null;

    /**
    *  パスに対してアクセス制限を行う
    * 
    */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
        throws IOException, ServletException
    {
        boolean found = false; 
        String ip_address = ((HttpServletRequest) request).getRemoteAddr();
        for(int i = 0; i<allow_ip.length; i++){
            if (ip_address.startsWith(allow_ip[i])) {
                found = true;
                chain.doFilter(request, response);
                return;
            }
        }
        if(!found){
            ((HttpServletResponse) response).sendError(HttpServletResponse.SC_FORBIDDEN);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        String[] allows = config.getInitParameter("allowIP").split(",");
        allow_ip = new String[allows.length];
        for(int i = 0; i<allows.length; i++){
            this.allow_ip[i] = allows[i].trim();
        }
    }

    public void destroy() {
        this.config = null;
        this.allow_ip = null;
    }
}
