<%@ page pageEncoding="UTF-8" contentType="text/html;charset=UTF-8" import="java.util.*, java.sql.*, bibliophilia.*, javax.naming.*, javax.sql.*" %>
<%

    BookInfo book = null;
    boolean error = false;
    String isbn = request.getParameter("isbn");

    if(isbn == null){
        isbn = "";
    }else {
        // find books
        isbn = isbn.replaceAll("-", "");
        isbn = isbn.replaceAll(" ", "");
    }
    String oldBookId = request.getParameter("bookid");
    if(oldBookId == null){
        oldBookId = "";
    }
%>
<html>
<head>
<jsp:include page="../htitle.jsp" />
<style type="text/css">
TH {
    background-color: #DDFFDD
}
</style>
<link rel="stylesheet" href="../style/common.css" TYPE="text/css">
</head>
<BODY>
<jsp:include page="../title.jsp" />
<TABLE>
<jsp:include page="../menu.jsp"/>
<TD valign="TOP">
<H2>ISBN/ASINコードで登録</H2>
<%
    book = BookInfo.getInfoByISBN(isbn.trim());
    error = false;
    if(null == book.getISBN() ||  book.getISBN().equals("")){
        out.println("該当する書籍はありませんでした");
        out.println("<p>");
    }else {
        try {
            InitialContext ic = new InitialContext();
            DataSource ds = (DataSource)ic.lookup("java:comp/env/jdbc/bibliophilia");
            Connection con = ds.getConnection();

            if(oldBookId.length() > 0){
                int x = Integer.parseInt(oldBookId);
                PreparedStatement ds1 = con.prepareStatement("delete from books where book_id=?");
                ds1.setInt(1, x);
                ds1.executeUpdate();
                ds1.close();
                PreparedStatement ds2 = con.prepareStatement("delete from author where book_id=?");
                ds2.setInt(1, x);
                ds2.executeUpdate();
                ds2.close();
            }

            Statement stmt0 = con.createStatement();
            ResultSet rs = stmt0.executeQuery("select nextval('seq_book_id')");
            rs.next();
            int book_id = rs.getInt(1);
            PreparedStatement stmt = 
                con.prepareStatement("insert into books (book_id, isbn, title, reg_date, manufacturer) values(?, ?, ?, ?, ?)");
            PreparedStatement roles = con.prepareStatement("insert into author (book_id, arole, name) values(?, ?, ?)");
            stmt.setInt(1, book_id);
            stmt.setString(2, book.getISBN());
            stmt.setString(3, book.getTitle());
            stmt.setDate(4, new java.sql.Date(System.currentTimeMillis() ));
            stmt.setString(5, book.getManufacturer());
            stmt.executeUpdate();
            Vector<Creator> creators = book.getCreators();
            for(Creator c: creators){
                roles.setInt(1, book_id);
                roles.setString(2, c.getRole());
                roles.setString(3, c.getName());
                roles.executeUpdate();
            }
            stmt0.close();
            stmt.close();
            roles.close();
            rs.close();
            con.close();
        }catch(Exception e){
            e.printStackTrace();
            out.println("エラーのため登録できませんでした。");
            error = true;
        }finally {
        }
    }
    %>
    <%
    if(!error){
        out.println("<table><TD rowspan='6'>");
        String[] images = book.getImage();
        if(images[1] != null){
            out.println("<a href='" + images[2]+ "'><img src='"+ images[1] +"'></A>");
        }else {
            out.println("[No Image]");
        }
        %>
        <TR><TH>タイトル
        <TD><%=book.getTitle() %>
        <TR><TH>ISBN
        <TD><%=book.getISBN() %>
        <TR><TH>出版社
        <TD><%=book.getManufacturer() %>
        <TR><TH>詳細
        <TD><a href='http://www.amazon.co.jp/exec/obidos/ASIN/<%=book.getISBN()%>'>Amazonの情報</A>
        <TR><TH>著者
        <TD>
        <%
            Vector<Creator> creators = book.getCreators();
            for(Creator c: creators){
                out.println(c.getName() + "<BR>");
            }
        %>
        </table>
        <p>
        以上の情報が登録されました。
        <%
    }
%>
</TABLE>
</body>
</html>
<%
/*
    Column    |          Type          | Modifiers
--------------+------------------------+-----------
 book_id      | integer                | not null
 isbn         | character varying(16)  |
 title        | character varying(512) |
 reg_date     | date                   |
 manufacturer | character varying(256) |
 user_id      | integer                |
 */
%>
