<%@ page pageEncoding="UTF-8" contentType="text/html;charset=UTF-8" import="java.util.*, java.io.*, bibliophilia.*, javax.naming.*, javax.sql.*" %>
<%!
    public static String encode(String s) throws UnsupportedEncodingException {
        return java.net.URLEncoder.encode(s, "UTF-8");
    }
%>
<%
    boolean error = false;
    String title = null;
    String isbn = null;
    String reg_date = null;
    String publisher = null;
    Vector<Creator> creators = null;

    error = false;
    title = request.getParameter("title");
    isbn = request.getParameter("isbn");
    reg_date = request.getParameter("reg_date");
    publisher = request.getParameter("publisher");
    String[] tmp = request.getParameter("authors").split("\n");
    creators = new Vector<Creator>();
    for(int i = 0; i<tmp.length; i++){
        tmp[i] = tmp[i].trim();
        if(tmp[i].length() == 0){
            continue;
        }
        tmp[i] = tmp[i].replaceFirst("：", ":");
        String[] line = tmp[i].split(":");
        if(line.length == 1){
            creators.add(new Creator("著", line[0]));
        }else if(line.length > 1){
            creators.add(new Creator(line[0].trim(), line[1].trim()));
        }
    }

%>
<html>
<head>
<jsp:include page="../htitle.jsp" />
<style type="text/css">
TH {
    background-color: #DDFFDD
}
</style>
<link rel="stylesheet" href="../style/common.css" TYPE="text/css">
</head>
<BODY>
<jsp:include page="../title.jsp" />
<TABLE>
<jsp:include page="../menu.jsp"/>
<TD valign="TOP">
<H2>入力の確認</H2>
この内容でよければ登録してください。
<p>
<form name="man_form" method="post" action="reg_man3.jsp" />
<TABLE>
    <TH>書籍名
    <TD><%=title%><input type="hidden" name="title" value="<%=encode(title)%>" />
<TR>
    <TH>ISBN/ASIN
    <TD><%=isbn%><input type="hidden" name="isbn" value="<%=encode(isbn)%>" />
<TR>
    <TH>登録日
    <TD><%=reg_date %><input type="hidden" name="reg_date" value="<%=encode(reg_date)%>" />
<TR>
    <TH>出版社
    <TD><%=publisher%><input type="hidden" name="publisher" value="<%=encode(publisher)%>" />
<TR>
    <TH>著者
    <TD>
    <pre><%
        StringBuilder sb = new StringBuilder();
        for(Creator c: creators){
            out.println(c.getRole() + ": " + c.getName());
            sb.append(c.getRole() + ":" + c.getName() + "\n");
        }
        out.println("<input type='hidden' name='authors' value='"+ encode(sb.toString()) + "' />");
    %></pre>
<TR>
    <TH>
    <TD><input type="submit" value="登録" />
    <input type="button" onClick="javascript: back()" value="戻る"/>
</TABLE>
</form>
</body>
</html>
<%
/*
    Column    |          Type          | Modifiers
--------------+------------------------+-----------
 book_id      | integer                | not null
 isbn         | character varying(16)  |
 title        | character varying(512) |
 reg_date     | date                   |
 manufacturer | character varying(256) |
 user_id      | integer                |
 */
%>
