<%@ page pageEncoding="UTF-8" contentType="text/html;charset=UTF-8" import="java.sql.*, java.util.*, java.io.*, bibliophilia.*, javax.naming.*, javax.sql.*" %>
<%!
    public static String decode(String s) throws UnsupportedEncodingException {
        return java.net.URLDecoder.decode(s, "UTF-8");
    }
%>
<%
    boolean error = false;
    String title = null;
    String isbn = null;
    String reg_date = null;
    String publisher = null;
    Vector<Creator> creators = null;
    int book_id = 0;

    error = false;
    title = decode(request.getParameter("title"));
    isbn = decode(request.getParameter("isbn"));
    reg_date = decode(request.getParameter("reg_date"));
    publisher = decode(request.getParameter("publisher"));
    String[] tmp = decode(request.getParameter("authors")).split("\n");
    creators = new Vector<Creator>();
    for(int i = 0; i<tmp.length; i++){
        tmp[i] = tmp[i].trim();
        if(tmp[i].length() == 0){
            continue;
        }
        tmp[i] = tmp[i].replaceFirst("：", ":");
        String[] line = tmp[i].split(":");
        if(line.length == 1){
            creators.add(new Creator("著", line[0]));
        }else if(line.length > 1){
            creators.add(new Creator(line[0].trim(), line[1].trim()));
        }
    }

%>
<html>
<head>
<jsp:include page="../htitle.jsp" />
<style type="text/css">
TH {
    background-color: #DDFFDD
}
</style>
<link rel="stylesheet" href="../style/common.css" TYPE="text/css">
</head>
<BODY>
<jsp:include page="../title.jsp" />
<TABLE>
<jsp:include page="../menu.jsp"/>
<TD valign="TOP">
    <% 
    Connection con = null;
    try {
        InitialContext ic = new InitialContext();
        DataSource ds = (DataSource)ic.lookup("java:comp/env/jdbc/bibliophilia");
        con = ds.getConnection();
        con.setAutoCommit(false);
        PreparedStatement stmt = con.prepareStatement("select nextval('seq_book_id')");
        ResultSet rs = stmt.executeQuery();
        rs.next();
        book_id = rs.getInt(1);
        rs.close();
        stmt.close();
        stmt = con.prepareStatement("insert into books(book_id, isbn, title, reg_date, manufacturer, user_id)"
            + " values(?, ?, ?, ?, ?, -1)");
        stmt.setInt(1, book_id);
        stmt.setString(2, isbn);
        stmt.setString(3, title);
        stmt.setDate(4, java.sql.Date.valueOf(reg_date));
        stmt.setString(5, publisher);
        stmt.executeUpdate();
        stmt.close();
        stmt = con.prepareStatement("insert into author(book_id, arole, name) values(?, ?, ?)");
        for(Creator c: creators){
            stmt.setInt(1, book_id);
            stmt.setString(2, c.getRole());
            stmt.setString(3, c.getName());
            stmt.executeUpdate();
        }
        stmt.close();
        con.commit();
        con.close();
    }catch(Exception e){
        try {
            con.rollback();
        }catch(Exception e2){
            e2.printStackTrace();
        }
        e.printStackTrace();
        error = true;
    }
    if(!error){
        out.println("<H2>登録完了</H2>");
        out.println("<a href='/bibliophilia/bookinfo.jsp?rent_book=-1&id="+book_id+"'>書籍の情報へ</A>");
    }else {
        out.println("<H2>登録中にエラーが発生しました。</H2>");
    }
    %>
</table>
</body>
</html>
<%
/*
    Column    |          Type          | Modifiers
--------------+------------------------+-----------
 book_id      | integer                | not null
 isbn         | character varying(16)  |
 title        | character varying(512) |
 reg_date     | date                   |
 manufacturer | character varying(256) |
 user_id      | integer                |
 */
%>
