<%@ page pageEncoding="UTF-8" contentType="text/html;charset=UTF-8" import="java.util.*, java.sql.*, bibliophilia.*, javax.naming.*, javax.sql.*" %>
<%
    String url = "http://webservices.amazon.co.jp/onca/xml?"
      + "Service=AWSECommerceService"
      + "&Version=2005-03-23"
      + "&Operation=ItemSearch"
      + "&ContentType=text%2Fxml"
      + "&SubscriptionId=0525E2PQ81DD7ZTWTK82"
      + "&SearchIndex=Books"
      + "&ResponseGroup=Images,ItemAttributes,ItemIds"
      + "&Keywords=";
    String keywords = request.getParameter("keywords");

    if(keywords == null){
        keywords = "";
    }else {
        keywords = keywords.replaceAll("　", " ");
        // find books
    }
    String english = request.getParameter("english");
    if(english != null && english.equals("on")){
        url = url.replaceFirst("co.jp/", "com/");
    }

    String oldBookId = request.getParameter("bookid");
    if(oldBookId == null){
        oldBookId = "";
    }
%>
<html>
<head>
<jsp:include page="../htitle.jsp" />

<style type="text/css">
TH {
    background-color: #DDFFDD
}
</style>
<link rel="stylesheet" href="../style/common.css" TYPE="text/css">
</head>
<BODY>
<jsp:include page="../title.jsp" />
<TABLE>
<jsp:include page="../menu.jsp"/>
<TD valign="TOP">
<H2>書籍名で登録</H2>
<P>
書籍名を入力して検索した後、候補の中から
登録するものを選択してください。
<form method="post" action="reg_name.jsp">
キーワード
<input type="text" name="keywords" value="<%=keywords%>" size="80" />
<input type="submit" value="検索">
<input type="checkbox" name="english" />米国Amazonで検索
<input type="hidden" name="bookid" value="<%=oldBookId%>" />
<BR>
</form>
<%
  if(keywords != null && !keywords.trim().equals("")){
      keywords = java.net.URLEncoder.encode(keywords, "UTF-8");
      url += keywords;
      AmazonSearch amazon = new AmazonSearch();
      Book[] books = amazon.find(url);
      out.println("<BR>" + amazon.getLastFound() + "件見つかりました。表示しきれていない場合はキーワードを追加してください");
      out.println("<TABLE><TH><TH>タイトル<TH>ISBN<TH>種類<TH>");
      for(int i = 0; i<books.length; i++){
          out.println("<TR>");
          String[] images = books[i].getImages();
          if(images[0] == null){
              out.println("<TD>[No Image]");
          }else {
              out.println("<TD><img src='" + images[0] + "'>");
          }
          out.println("<TD><a href='http://www.amazon.co.jp/exec/obidos/ASIN/" +  books[i].getISBN() +"' target='_new'>"
            + books[i].getTitle() + "</A>");
          out.println("<TD>" + books[i].getISBN());
          out.println("<TD>" + books[i].getBinding());
          out.println("<TD><form method='POST' action='reg_book.jsp'>");
          out.println("       <input type='hidden' name='bookid' value='" + oldBookId + "'>");
          out.println("       <input type='hidden' name='isbn'   value='" + books[i].getISBN() + "'>");
          out.println("  <input type='submit' value='これを登録' /> </form>");
      }
      // out.println("<BR>" + url);
      out.println("</TABLE>");
  }

%>
</TABLE>
</body>
</html>
<%
/*
    Column    |          Type          | Modifiers
--------------+------------------------+-----------
 book_id      | integer                | not null
 isbn         | character varying(16)  |
 title        | character varying(512) |
 reg_date     | date                   |
 manufacturer | character varying(256) |
 user_id      | integer                |
 */
%>
