<%@ page pageEncoding="UTF-8" contentType="text/html;charset=UTF-8" import="java.sql.*, java.util.*, java.io.*, bibliophilia.*, javax.naming.*, javax.sql.*" %>
<%!
    public static String decode(String s) throws UnsupportedEncodingException {
        return java.net.URLDecoder.decode(s, "UTF-8");
    }
%>
<%
    int book_id = Integer.parseInt(request.getParameter("book_id"));
    boolean error = false;
    String title = request.getParameter("title");
    String isbn = request.getParameter("isbn");
    java.sql.Date reg_date = java.sql.Date.valueOf(request.getParameter("reg_date"));
    String publisher = (request.getParameter("publisher"));
    String[] tmp = (request.getParameter("authors")).split("\n");
    String comment = request.getParameter("comment");
    boolean auto_isbn_completion = false;
    if(null != request.getParameter("auto_isbn_completion")){
        request.getParameter("auto_isbn_completion").equals("on");
    }

    Vector<Creator> creators = new Vector<Creator>();
    for(int i = 0; i<tmp.length; i++){
        tmp[i] = tmp[i].trim();
        if(tmp[i].length() == 0){
            continue;
        }
        tmp[i] = tmp[i].replaceFirst("：", ":");
        String[] line = tmp[i].split(":");
        if(line.length == 1){
            creators.add(new Creator("著", line[0]));
        }else if(line.length > 1){
            creators.add(new Creator(line[0].trim(), line[1].trim()));
        }
    }

    if(auto_isbn_completion){
        if(isbn == null){
            isbn = "";
        }else {
            // find books
            isbn = isbn.replaceAll("-", "");
            isbn = isbn.replaceAll(" ", "");
        }
        if(isbn.length() == 13){
            isbn = IsbnUtil.toOldSystem(isbn);
        }
        if(isbn.length() == 9){
            isbn = IsbnUtil.completeCheckDigit10(isbn);
        }
    }

%>
<html>
<head>
<jsp:include page="../htitle.jsp" />
<style type="text/css">
TH {
    background-color: #DDFFDD
}
</style>
<link rel="stylesheet" href="../style/common.css" TYPE="text/css">
</head>
<BODY>
<jsp:include page="../title.jsp" />
<TABLE>
<jsp:include page="../menu.jsp"/>
<TD valign="TOP">
    <% 
    Connection con = null;
    try {
        InitialContext ic = new InitialContext();
        DataSource ds = (DataSource)ic.lookup("java:comp/env/jdbc/bibliophilia");
        con = ds.getConnection();
        con.setAutoCommit(false);

        PreparedStatement stmt = con.prepareStatement("update books set isbn=?, title=?, reg_date=?, manufacturer=?, comment=? where book_id=?");
        stmt.setInt(6, book_id);
        stmt.setString(1, isbn);
        stmt.setString(2, title);
        stmt.setDate(3, reg_date);
        stmt.setString(4, publisher);
        stmt.setString(5, comment);
        // stmt.setString(2, title);
        stmt.executeUpdate();
        stmt.close();

        stmt = con.prepareStatement("delete from author where book_id=?");
        stmt.setInt(1, book_id);
        stmt.executeUpdate();
        stmt.close();

        stmt = con.prepareStatement("insert into author(book_id, arole, name) values(?, ?, ?)");
        for(Creator c: creators){
            stmt.setInt(1, book_id);
            stmt.setString(2, c.getRole());
            stmt.setString(3, c.getName());
            stmt.executeUpdate();
        }
        stmt.close();
        con.commit();
        con.close();
    }catch(Exception e){
        try {
            con.rollback();
        }catch(Exception e2){
            e2.printStackTrace();
        }
        e.printStackTrace();
        error = true;
    }
    if(!error){
        out.println("<H2>情報を更新しました</H2>");
        out.println("<a href='/bibliophilia/bookinfo.jsp?rent_book=-1&id="+book_id+"'>書籍の情報へ</A>");
    }else {
        out.println("<H2>登録中にエラーが発生しました。</H2>");
    }
    %>
</table>
</body>
</html>
<%
/*
    Column    |          Type          | Modifiers
--------------+------------------------+-----------
 book_id      | integer                | not null
 isbn         | character varying(16)  |
 title        | character varying(512) |
 reg_date     | date                   |
 manufacturer | character varying(256) |
 user_id      | integer                |
 */
%>
