/*
**  bifdp_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/07/22.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIFDP/A, as mechanically as possible.
**
*/


#if !defined BIFDP_A_H
#define BIFDP_A_H


#include "bifu_i.h"
#include "bif_m.h"


extern cell_u	UP;	/* [DP]    pointer to the per-USER variable table (USER Pointer) */
extern cell_u	* IP;	/* Y       Pointer to the next definition to execute (Instruction Pointer). */
extern cell_u	* RP;	/* S       return/control stack pointer */
extern cell_u	* SP;	/* U       parameter/data stack pointer */
/* W was originally (ephemeral) on the 6809 stack because there weren't enough registers. */
extern cell_u	W;	/* [S]     pointer to executing definition's parameter field */
extern cell_u	sysSIG;	/* Added as a way to break out of the inner interpreter. */


#define SPARE_REG_COUNT	8	/* Don't know if these will be useful. */
extern cell_u spares[ SPARE_REG_COUNT ];


/* The inner interpreter: 
*/
extern void XNEXT (void);

/* Nest into an icode list.
*/
extern void XCOL(void);

/* Push the first cell from the parameter field as a constant.
*/
extern void XCON(void);

/* Push the address of the first cell from the parameter field as a variable.
*/
extern void XVAR(void);

/* Push the address of a the per-task variable, base of USER PAGE + offset.
*/
extern void XUSER(void);

/* Push the address of the element of a 1 dimensional bounded array.
*/
extern void X1ARR(void);

/* Push the value of a user variable as a constant.
*/
extern void XUCON(void);

/* Stores a pointer to itself in the search context root pointer.
*/
extern void XVOC(void);

/* Start into a characteristic that is defined high-level.
*/
extern void XDOES(void);

/* Push the first two cells from the parameter field as a double-width constant.
*/
extern void XDCON(void);


#endif /* !defined BIFDP_A_H */
