/* Fith: booting and testing
//
// [Author(s)]
// Joel Rees, from November 2007 (JMR)
// All copyrights claimed and retained by the author(s).
// [License]
// This source may be used under the following conditions:
// * This source must be provided in some reasonable manner 
//   with any object distribution or publication.
// * This license notice may not be removed or modified.
// * Any modifications made to this file and published
//   shall receive the same license.
// * The author(s) make no legal representations whatsoever
//   concerning this source and the abstractions and/or
//   implementations contained therein:
// * Each user assumes all liability and responsibility
//   concerning such use.
// * USE AT YOUR OWN RISK.
// * The author(s) assert and concur that algorithms and 
//   other abstractions are fundamentally not patentable.
// * No other conditions are asserted.
// End of copyright and license notice.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define MAIN_H


#include "bifu_i.h"
#include "bif_a.h"

/* for debugging */
#if defined TRASH

#include	"dictnary.h"
#include	"inner.h"
#include	"basemath.h"


#define DBG_SPINITV1	0x3456CDEF
#define DBG_SPINITV2	0xCBA94322


int dbgL00( void )
{	// int retVal = 0;
	if ( !ii_init() ) 
	{	return( -1 );
	}
	t_defCellp dbg_spMemory = sp;
	/* i+ */
	printf( "DROP length: %lu %d\n", strlen( (char *) h_drop[ 2 ] ), ( ( (char *) h_drop[ 2 ] )[ 0 ] ) );
	printf( "initial sp: %8p\n", sp );
	( * --sp ) = DBG_SPINITV1;
	( * --sp ) = DBG_SPINITV2;
	printf( "\tloaded sp : %8p: %08lx %08lx\n", sp, sp[ 0 ], sp[ 1 ] );
	iPlus();
	printf( "\tsp after i+ : %8p: %08lx\n", sp, sp[ 0 ] );
	if ( sp[ 0 ] != ( DBG_SPINITV1 + DBG_SPINITV2 ) )
	{	printf( "\t%08lx != %08lx\n", sp[ 0 ], (unsigned long) ( DBG_SPINITV1 + DBG_SPINITV2 ) );
		return 1;
	}
	drop();
	if ( sp != dbg_spMemory )
	{	return 2;
	}
	/* i- */
	( * --sp ) = DBG_SPINITV1;
	( * --sp ) = DBG_SPINITV2;
	printf( "\tloaded sp : %8p: %08lx %08lx\n", sp, sp[ 0 ], sp[ 1 ] );
	iMinus();
	printf( "\tsp after i- : %8p: %08lx\n", sp, sp[ 0 ] );
	if ( sp[ 0 ] != ( DBG_SPINITV1 - DBG_SPINITV2 ) )
	{	printf( "\t%08lx != %08lx\n", sp[ 0 ], (unsigned long) ( DBG_SPINITV1 - DBG_SPINITV2 ) );
		return 3;
	}
	drop();
	if ( sp != dbg_spMemory )
	{	return 4;
	}
	return 0;
}

t_defCell h_testInner[] =	
{	RUNNABLE,
	(t_unsigned) inner,
	(t_unsigned) "\010xliteral", 
	NULL,	/* h_basemath, */	/* owning vocabulary */
	NULL,	/* left */
	NULL,	/* right */
	NULL /* (t_unsigned) h_test */ ,
	NULL,	/* spare, i-code follows */
//	(t_unsigned) h_inner,
	(t_unsigned) h_xliteral,
	DBG_SPINITV1,
	(t_unsigned) h_xliteral,
	DBG_SPINITV2,
	(t_unsigned) h_iPlus,
	(t_unsigned) h_xliteral,
	DBG_SPINITV1,
	(t_unsigned) h_xliteral,
	DBG_SPINITV2,
	(t_unsigned) h_iMinus,
//	(t_unsigned) h_unnest,
	NULL	/* Probably want to terminate all the definition strings with NULL, as a firewall. */
};

int dbgL01( void )
{	int state = dbgL00();
	t_icode wmark;
	if ( state )
	{	return state; 
	}
	printf( "Let's try the inner interpreter:\n" );
	wmark = w = &h_testInner;
	inner();
	printf( "\tsp after inner interpreter run : %8p: %08lx %08lx\n", sp, sp[ 0 ], sp[ 1 ] );
	return 0;
}

t_icode testPlus[] =
{	
};

#endif /* defined TRASH */

int main (int argc, const char * argv[]) 
{
    // insert code here...
    printf( "Hello, World!\n" );
	/* printf( "%d\n", dbgL01() ); */
    return 0;
}
