/*
**  bif1b_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF1B/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */

#include "bif1_a.h"		/* For the allocation link to ADDSTO, also, SEMIS */

#include "bif2_a.h"	/* For ZERO, etc. */
#include "bif2b_a.h"	/* For HERE, ALLOC, etc. */
#include "bif4_a.h"	/* For MOD, etc. */
#include "bif4b_a.h"	/* For QERR, etc. */
#include "bif6_a.h"	/* For DDFIND, etc. */
#include "bif7_a.h"	/* For CREATE, etc. */

#include "bif1b_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
05160 	FCC 'TOGGLE'
05170 	FCB 6
05180 	FCB MFORE
05190 	FDB ADDSTO-CFAOFF
05200 	FDB BIF+2
05210 	FDB TIB-CFAOFF
05220 	FDB TYPE-CFAOFF
*/
static character_t sTOG[] = "\x6" "TOGGLE";
definition_header_s hTOG =	
{	{ (natural_t) sTOG },
	{ 0 },
	{ (natural_t) &hADDSTO },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hTIB },
	{ (natural_t) &hTYPE },
	{ (natural_t) TOG }
};
/*
05230 TOG	PULU D,X
05240 	EORB ,X
05250 	STB ,X
05260 	NEXT
05270 *
*/
void TOG(void)
{	byte_t * target = SP[ 1 ].bytep;
	( * target ) ^= (byte_t) SP[ 0].integer;	/* Make sure we get the low byte. */
	SP += 2;
}


/*
05280 	FCC 'C@'
05290 	FCB 2
05300 	FCB MFORE
05310 	FDB TOG-CFAOFF
05320 	FDB BIF+2
05330 	FDB BUFFER-CFAOFF
05340 	FDB DADD-CFAOFF
*/
static character_t sCFEH[] = "\x2" "C@";
definition_header_s hCFEH =	
{	{ (natural_t) sCFEH },
	{ 0 },
	{ (natural_t) &hTOG },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hBUFFER },
	{ (natural_t) &hDADD },
	{ (natural_t) CFEH }
};
/*
05350 CFEH	LDB [,U]
05360 	CLRA
05370 	STD ,U
05380 	NEXT
05390 *
*/
void CFEH(void)
{	byte_t * source = SP[ 0 ].bytep;
	SP[ 0 ].integer = * source;
}


/*
05400 	FCC 'C!'
05410 	FCB 2
05420 	FCB MFORE
05430 	FDB CFEH-CFAOFF
05440 	FDB BIF+2
05450 	FDB 0
05460 	FDB 0
*/
static character_t sCSTO[] = "\x2" "C!";
definition_header_s hCSTO =	
{	{ (natural_t) sCSTO },
	{ 0 },
	{ (natural_t) &hCFEH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) CSTO }
};
/*
05470 CSTO	LDB 3,U
05480 	STB [,U]
05490 	LEAU 4,U
05500 	NEXT
05510 *
*/
void CSTO(void)
{	byte_t * target = SP[ 0 ].bytep;
	* target = (byte_t) SP[ 1 ].integer;
	SP += 2;
}


/*
05520 	FCC 'ROT'
05530 	FCB 3
05540 	FCB MFORE
05550 	FDB CSTO-CFAOFF
05560 	FDB BIF+2
05570 	FDB RFROM-CFAOFF
05580 	FDB SMUDGE-CFAOFF
*/
static character_t sROT[] = "\x3" "ROT";
definition_header_s hROT =	
{	{ (natural_t) sROT },
	{ 0 },
	{ (natural_t) &hCSTO },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hRFROM },
	{ (natural_t) &hSMUDGE },
	{ (natural_t) ROT }
};
/*
05590 ROT	PSHS Y
05600 	PULU D,X,Y
05610 	PSHU D,X
05620 	PSHU Y
05630 	PULS Y
05640 	NEXT
05650 *
*/
void ROT(void)
{	cell_u temp = SP[ 2 ];
	SP[ 2 ] = SP[ 1 ];
	SP[ 1 ] = SP[ 0 ];
	SP[ 0 ] = temp;
}


/*
05660 	FCC 'BACK' back ref
05670 	FCB MCOMP.OR.4
05680 	FCB MFORE
05690 	FDB ROT-CFAOFF
05700 	FDB BIF+2
05710 	FDB BPBUF-CFAOFF
05720 	FDB BEGIN-CFAOFF
*/
static character_t sBACK[] = "\x4" "BACK";
definition_header_s hBACK =	
{	{ (natural_t) sBACK },
	{ MCOMP },
	{ (natural_t) &hROT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hBPBUF },
	{ (natural_t) &hBEGIN },
	{ (natural_t) BACK }
};
/*
05730 BACK	LDX <UP
05740 	PULU D target
05750 	SUBD UDP,X here
05755 	SUBD #2 past
05760 	PSHU D
05770 	JMP COMMA
05780 *
*/
void BACK(void)
{	/*
	snatural_t offset = SP[ 0 ].bytep - ( * UP.task ).dictionaryAllocationPointer.bytep - sizeof (cell_u);
	SP[ 0 ].integer = offset;
	COMMA();
	*/
	HERE();
	SUB();
	--( SP[ 0 ].cellp );	
	COMMA();
}


/*
05800 	FCC 'NOT'
05810 	FCB 3
05820 	FCB MFORE
05830 	FDB BACK-CFAOFF
05840 	FDB BIF+2
05850 	FDB NDOT-CFAOFF
05860 	FDB 0
*/
static character_t sNOT[] = "\x3" "NOT";
definition_header_s hNOT =	
{	{ (natural_t) sNOT },
	{ 0 },
	{ (natural_t) &hBACK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hNDOT },
	{ 0 },
	{ (natural_t) NOT }
};
/*
05870 NOT	LDD ,U
05880 	COMB
05890 	COMA
05900 	STD ,U
05910 	NEXT
05920 *
*/
void NOT(void)
{	SP[ 0 ].integer = ~SP[ 0 ].integer;
}


/*
05990 	FCC /'/
06000 	FCB MIMM.OR.1
06010 	FCB MFORE
06020 	FDB NOT-CFAOFF
06030 	FDB BIF+2
06040 	FDB HASHS-CFAOFF
06050 	FDB 0
06055 * ' see fig-FORTH model
*/
static character_t sTICK[] = "\x1" "'";
definition_header_s hTICK =	
{	{ (natural_t) sTICK },
	{ MIMM },
	{ (natural_t) &hNOT },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hHASHS },
	{ 0 },
	{ (natural_t) XCOL },
/*
06060 TICK	DOCOL
06070 	FDB DDFIND
06080 	FDB DROP
06090 	FDB DUP
06100 	FDB ZEQ
06110 	FDB ZERO
06120 	FDB QERR
06130 	FDB LITER
06140 	FDB SEMIS
06150 *
*/
	{	{ (natural_t) &hDDFIND	},
		{ (natural_t) &hDROP	},
		{ (natural_t) &hDUP	},
		{ (natural_t) &hZEQ	},
		{ (natural_t) &hZERO	},
		{ (natural_t) &hQERR	},
		{ (natural_t) &hLITER	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
07000 	FCC '-->'
07010 	FCB MIMM.OR.3
07020 	FCB MFORE
07030 	FDB TICK-CFAOFF
07040 	FDB BIF+2
07050 	FDB PLOOP-CFAOFF
07060 	FDB DOT-CFAOFF
07065 * --> see fig-FORTH model
*/
static character_t sNEXSCR[] = "\x3" "-->";
definition_header_s hNEXSCR =	
{	{ (natural_t) sNEXSCR },
	{ MIMM },
	{ (natural_t) &hTICK },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hPLOOP },
	{ (natural_t) &hDOT },
	{ (natural_t) XCOL },
/*
07070 NEXSCR	DOCOL
07080 	FDB QLOAD
07090 	FDB ZERO
07100 	FDB IN
07110 	FDB STORE
07120 	FDB BPSCR
07130 	FDB BLK
07140 	FDB FETCH
07150 	FDB OVER
07160 	FDB MOD remaining in screen
07170 	FDB SUB
07180 	FDB BLK
07190 	FDB ADDSTO to next
07200 	FDB SEMIS
07290 *
*/
	{	{ (natural_t) &hQLOAD	},
		{ (natural_t) &hZERO	},
		{ (natural_t) &hIN	},
		{ (natural_t) &hSTORE	},
		{ (natural_t) &hBPSCR	},
		{ (natural_t) &hBLK	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hOVER	},
		{ (natural_t) &hMOD	},	/* remaining in screen */
		{ (natural_t) &hSUB	},
		{ (natural_t) &hBLK	},
		{ (natural_t) &hADDSTO	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
07300 	FCC '1ARRAY'
07310 	FCB 6
07320 	FCB MFORE
07330 	FDB NEXSCR-CFAOFF
07340 	FDB BIF+2
07350 	FDB SUB1-CFAOFF
07360 	FDB TBR-CFAOFF
*/
static character_t sONEARR[] = "\x6" "1ARRAY";
definition_header_s hONEARR =	
{	{ (natural_t) sONEARR },
	{ 0 },
	{ (natural_t) &hNEXSCR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSUB1 },
	{ (natural_t) &hTBR },
	{ (natural_t) XCOL },
/*
07370 ONEARR	DOCOL
07380 	FDB CREATE
07390 	FDB IPCOM
07400 	DO1ARR
07410 	FDB XMACH
07415 	LDX ,U
07420 	CMPX #255	0<el-size<256
07430 	BLS ONEARW
07440 ONEARE	LDD #$0D
07450 	PSHU D
07460 	LBRA ERROR
07470 ONEARW	LDD 4,U		swap
07480 	STD ,U
07490 	STX 4,U
07500 	LDD 2,U		last
07510 	SUBD ,U		first
07520 	BLT ONEARE	real dimension?
07530 	ADDD #1	element count
07540 	STD 2,U
07550 	PSHU D,X
07560 	DOCOL
07570 	FDB USTAR
07580 	FDB LIT	overflow?
07590 	FDB $0D
07600 	FDB QERR
07610 	FDB TOR	byte count
07620 	FDB COMMA	base
07630 	FDB COMMA	width
07640 	FDB CCOMMA	element size
07650 	FDB RFROM
07660 	FDB ALLOT
07670 	FDB SMUDGE
07680 	FDB SEMIS
07690 *
*/
	{
		{ (natural_t) &hCREATE	},
		{ (natural_t) &hIPCOM	},
		{ (natural_t) X1ARR	},
		{ (natural_t) &hDUP	},	/* 0 <= element width <= max */
		{ (natural_t) &hZERO	},	/* Allowing zero width, to be perverse. */
		{ (natural_t) &hLT	},
		{ (natural_t) &hOVER	},
		{ (natural_t) &hLIT	},
		{ ARRAY_EL_MAX_WIDTH	},	/* This could be a per-USER constant, eventually. */
		{ (natural_t) &hGT	},
		{ (natural_t) &hOR	},
		{ (natural_t) &hLIT	},	/* element size okay? */
		{ ARRAY_DIMENSION_NOT_VALID	},
		{ (natural_t) &hQERR	},
		{ (natural_t) &hUSTAR	},
		{ (natural_t) &hLIT	},	/* overflow? Probably want to check this more carefully. */
		{ ARRAY_DIMENSION_NOT_VALID	},
		{ (natural_t) &hQERR	},
		{ (natural_t) &hTOR	},	/* byte count */
		{ (natural_t) &hCOMMA	},	/* base */
		{ (natural_t) &hCOMMA	},	/* width */
		{ (natural_t) &hCCOMMA	},	/* element size */
		{ (natural_t) &hRFROM	},
		{ (natural_t) &hALLOT	},
		{ (natural_t) &hSMUDGE	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
07700 	FCC 'UTILITIES'
07710 	FCB MIMM.OR.9
07720 	FCB MFORE
07730 	FDB ONEARR-CFAOFF
07740 	FDB BIF+2
07750 	FDB 0
07760 	FDB 0
*/
static character_t sUTIL[] = "\x9" "UTILITIES";
definition_header_s hUTIL = 
{	{ (natural_t) sUTIL },
	{ MIMM },
	{ (natural_t) &hONEARR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XVOC },
	{	{ (natural_t) &hDPFEH	}
	}
};
/*
07770 UTIL	DOVOC
07780 	FDB DPFEH-CFAOFF
07890 *
07900 	FCC 'DP@'
07910 	FCB 3
07920 	FCB MFORE
07930 	FDB UTIL-CFAOFF
07940 	FDB UTIL+2
07950 	FDB 0
07960 	FDB 0
*/
static character_t sDPFEH[] = "\x3" "DP@";
definition_header_s hDPFEH = 
{	{ (natural_t) sDPFEH },
	{ 0 },
	{ (natural_t) &hUTIL },
	{ MFORE },
	{ (natural_t) &hUTIL },
	{ (natural_t) &hCTS_TYPE },
	{ 0 },
	{ (natural_t) DPFEH }
};
/*
07970 DPFEH	TFR DP,A
07980 	CLRB
07990 	PSHU D
07992 	NEXT
07994 *
*/
void DPFEH( void )
{	/* ( * --SP ).bytep = memoryImage;	No, this would be a unsecure. */
	( * --SP ).bytep = (byte_t *) 0;	/* This will, at least, probably cause an access violation. */
}

/*
08000 	FCC 'DCONSTANT'
08010 	FCB 9
08020 	FCB MFORE
08030 	FDB DPFEH-CFAOFF
08040 	FDB BIF+2
08050 	FDB 0
08060 	FDB 0
*/
static character_t sDCON[] = "\x9" "DCONSTANT";
definition_header_s hDCON = 
{	{ (natural_t) sDCON },
	{ 0 },
	{ (natural_t) &hDPFEH },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
08070 DCON	DOCOL
08080 	FDB CREATE
08090 	FDB IPCOM
08100 	JSR <XDCON
08110 	FDB COMMA
08120 	FDB COMMA
08130 	FDB SMUDGE
08140 	FDB SEMIS
08390 *
*/
	{
		{ (natural_t) &hCREATE	},
		{ (natural_t) &hIPCOM	},
		{ (natural_t) XDCON	},
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hSMUDGE	},
		{ (natural_t) &hSEMIS	}
	}
};

#if defined SWAH_DEFINING
static character_t sSWAH[] = "\x4" "SWAH";
definition_header_s hSWAH = 
{	{ (natural_t) sSWAH },
	{ 0 },
	{ (natural_t) &hDCON },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSWAB },
	{ (natural_t) &hSWAN },
	{ (natural_t) SWAH }
};
void SWAH( void )	
{	byte_t temp = SP[ 0 ].packed_character[ 0 ];
	SP[ 0 ].packed_character[ 0 ] = SP[ 0 ].packed_character[ 1 ];
	SP[ 0 ].packed_character[ 1 ] = temp;
	temp = SP[ 0 ].packed_character[ 2 ];
	SP[ 0 ].packed_character[ 2 ] = SP[ 0 ].packed_character[ 3 ];
	SP[ 0 ].packed_character[ 3 ] = temp;
}
#endif /* defined SWAH_DEFINING */


/*
08300 	FCC 'SWAB'
08310 	FCB 4
08320 	FCB MFORE
08330 	FDB DCON-CFAOFF
08340 	FDB BIF+2
08350 	FDB 0
08360 	FDB SWAN-CFAOFF
*/
static character_t sSWAB[] = "\x4" "SWAB";
definition_header_s hSWAB = 
{	{ (natural_t) sSWAB },
	{ 0 },
	{ (natural_t) &hDCON },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ (natural_t) &hSWAN },
	{ (natural_t) SWAB }
};
/*
08370 SWAB	LDD ,U
08380 	STB ,U	LS byte
08390 	STA 1,U	MS byte
08400 	NEXT
*/
#if defined BYTESPERCELL && ( ( BYTESPERCELL & 1 ) != 0 )
#	warning "Hard to swap bytes on an uneven bytes per word architecture!"
#	warning "This probably does not do what you want!"
#endif /* defined BYTESPERCELL && ( ( BYTESPERCELL & 1 ) != 0 ) */
void SWAB( void )	/* This calls for a SWAW or SWAH or something, to swap 16 bit half-words. */
{	byte_t temp;
	int i;
	for ( i = 0; i < BYTESPERCELL - 1; i += 2 )
	{	temp = SP[ 0 ].packed_character[ i ];
		SP[ 0 ].packed_character[ i ] = SP[ 0 ].packed_character[ i + 1 ];
		SP[ 0 ].packed_character[ i + 1 ] = temp;
	}
}


/*
08490 *
08500 	FCC 'SWAN'
08510 	FCB 4
08520 	FCB MFORE
08530 	FDB SWAB-CFAOFF
08540 	FDB BIF+2
08550 	FDB 0
08560 	FDB 0
*/
static character_t sSWAN[] = "\x4" "SWAN";
definition_header_s hSWAN = 
{	{ (natural_t) sSWAN },
	{ 0 },
	{ (natural_t) &hSWAB },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) SWAN }
};
/*
08570 SWAN	LDA 1,U
08580 	LDB 1,U
08590 	LSRA
08600 	RORB
08610 	LSRA
08620 	RORB
08630 	LSRA
08640 	RORB
08650 	LSRA
08660 	RORB
08670 	STB 1,U
08680 	LDA ,U
08690 	LDB ,U
08700 	LSRA
08710 	RORB
08720 	LSRA
08730 	RORB
08740 	LSRA
08750 	RORB
08760 	LSRA
08770 	RORB
08780 	STB ,U
08790 	NEXT
08890 *
*/
#if defined BITSPERBYTE 
#define SWANSHIFT ( BITSPERBYTE / 2)
#	if ( BITSPERBYTE & 1 ) != 0
#	warning "Hard to swap nibbles on uneven bits per byte architecture!"
#	warning "This probably does not do what you want!"
#	endif /* ( BITSPERBYTE & 1 ) != 0 */
#	if ( BITSPERBYTE == 4 ) || ( BITSPERBYTE == 5 )
#define	SWANRIGHT 0x3
#	elif ( BITSPERBYTE == 6 ) || ( BITSPERBYTE == 7 )
#define	SWANRIGHT 0x7
#	elif ( BITSPERBYTE == 8 ) || ( BITSPERBYTE == 9 )
#define	SWANRIGHT 0xf
#	elif ( BITSPERBYTE == 10 ) || ( BITSPERBYTE == 11 )
#define	SWANRIGHT 0x1f
#	elif ( BITSPERBYTE == 12 ) || ( BITSPERBYTE == 13 )
#define	SWANRIGHT 0x3f
#	elif ( BITSPERBYTE == 14 ) || ( BITSPERBYTE == 15 )
#define	SWANRIGHT 0x7f
#	else /* ( BITSPERBYTE == 6 ) || ( BITSPERBYTE == 7 ) */
#error "Don't know what to do with swap nibble. Check your nibble size."
#	endif /* ( BITSPERBYTE == 6 ) || ( BITSPERBYTE == 7 ) */
#define SWANLEFT ( SWANRIGHT << SWANSHIFT )
#endif /* defined BITSPERBYTE */ 
void SWAN( void )
{	byte_t ltemp, rtemp;
	int i;
	for ( i = 0; i < BYTESPERCELL; ++i )
	{	ltemp = ( SP[ 0 ].packed_character[ i ] & SWANLEFT ) >> SWANSHIFT;
		rtemp = ( SP[ 0 ].packed_character[ i ] & SWANRIGHT ) << SWANSHIFT;
		SP[ 0 ].packed_character[ i ] &= ~( SWANLEFT | SWANRIGHT );
		SP[ 0 ].packed_character[ i ] |= ltemp | rtemp;
	}
}
