/*
**  bif3b_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF3B/A, as mechanically as possible.
*/


#if !defined BIF3B_A_H
#define BIF3B_A_H


#include "bifu_i.h"


extern definition_header_s hTYPE;
extern void TYPE(void);

extern definition_header_s hCTS_TYPE;

extern definition_header_s hXDOTQ;
extern void XDOTQ(void);

extern definition_header_s hIDDOT;
extern void IDDOT(void);

extern definition_header_s hFILLIN;
extern void FILLIN(void);

/* I eventually want to make this byte-order independent, too. 
*/
#define	BEGIN_FLAG	( ( 'B' << 24 ) + ( 'E' << 16 ) + ( 'G' << 8 ) + 'I' )
/* #define	BEGIN_FLAG	( 'BEGI' ) */

extern definition_header_s hBEGIN;

extern definition_header_s hAGAIN;

extern definition_header_s hUNTIL;

/* I eventually want to make this byte-order independent, too. 
*/
#define	WHILE_FLAG	( ( 'W' << 24 ) + ( 'H' << 16 ) + ( 'I' << 8 ) + 'L' )
/* #define	WHILE_FLAG	( 'WHIL' ) */

extern definition_header_s hWHILE;

extern definition_header_s hREPEAT;

/* I eventually want to make this byte-order independent, too. 
*/
#define	LOOP_FLAG	( ( 'D' << 24 ) + ( 'O' << 16 ) + ( 'L' << 8 ) + 'O' )
/* #define	LOOP_FLAG	( 'DOLO' ) */

extern definition_header_s hDO;


#endif /* !defined BIF3B_A_H */
