/*
**  bif7_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF7/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bif6b_a.h"	/* For the linear linked list, for VLIST. */
#include "bif3b_a.h"
#include "bif7b_a.h"	/* To link into the BIF vocabulary. */

#include "bif7_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
01000 	FCC 'CREATE'
01010 	FCB 6
01020 	FCB MFORE
01030 	FDB VLIST-CFAOFF
01040 	FDB BIF+2
01050 	FDB CR-CFAOFF
01060 	FDB CSP-CFAOFF
*/
static character_t sCREATE[] = "\x6" "CREATE";
definition_header_s hCREATE =	
{	{ (natural_t) sCREATE },
	{ 0 },
	{ (natural_t) &hVLIST },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hCR },
	{ (natural_t) &hCSP },
	{ (natural_t) XCOL },
/*
01070 CREATE	DOCOL
01080 	FDB DDFIND
01090 	FDB OVER
01100 	FDB ZBR
01110 	FDB CREATN-*-2
01120 	FDB SWAP nfa
01130 	FDB IDDOT
01135 	FDB SPACE
01140 	FDB LIT
01150 	FDB 4
01160 	FDB MESS
01170 	FDB SPACE
01190 	FDB NFA vocab
01200 	FDB IDDOT
01205 	FDB CR
01210 	FDB BRANCH
01220 	FDB 4
01230 CREATN	FDB DROP
01240 	FDB DROP
01250 	FDB NCOMMA
01260 	FDB CCOMMA length
01270 	FDB ZERO
01280 	FDB CCOMMA mode
01290 	FDB LATEST allocation link
01300 	FDB COMMA
01310 	FDB DUP nfa
01320 	FDB CURR
01330 	FDB STORE new LATEST
01340 	FDB ZERO vocab
01350 	FDB COMMA
01360 	FDB ZERO
01370 	FDB COMMA left
01380 	FDB ZERO
01390 	FDB COMMA right
01400 	FDB SMUDGE hide
01410 	FDB FOREMK
01420 	FDB DROOT
01430 	FDB FETCH
01440 	FDB PINSTA in vocab
01450 	FDB SEMIS
01490 *
*/
	{
		{ (natural_t) &hDDFIND	},
		{ (natural_t) &hOVER	},
		{ (natural_t) &hZBR	},
		{ (natural_t) 12 * sizeof (cell_u)	},	/* &hCREATN-*-2 */
		{ (natural_t) &hSWAP	},	/* nfa */
		{ (natural_t) &hIDDOT	},
		{ (natural_t) &hSPACE	},
		{ (natural_t) &hLIT	},
		{ (natural_t) 4	},
		{ (natural_t) &hMESS	},
		{ (natural_t) &hSPACE	},
		{ (natural_t) &hNFA	},	/* vocab */
		{ (natural_t) &hIDDOT	},
		{ (natural_t) &hCR	},
		{ (natural_t) &hBRANCH	},
		{ (natural_t) 2 * sizeof (cell_u)	},	/* 4 */
/* CREATN: */
		{ (natural_t) &hDROP	},
		{ (natural_t) &hDROP	},
		{ (natural_t) &hNCOMMA	},
		{ (natural_t) &hCCOMMA	},	/* length */
		{ (natural_t) &hZERO	},
		{ (natural_t) &hCCOMMA	},	/* mode */
		{ (natural_t) &hLATEST	},	/* allocation link */
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hDUP	},	/* nfa */
		{ (natural_t) &hCURR	},
		{ (natural_t) &hSTORE	},	/* new LATEST */
		{ (natural_t) &hZERO	},	/* vocab */
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hZERO	},
		{ (natural_t) &hCOMMA	},	/* left */
		{ (natural_t) &hZERO	},
		{ (natural_t) &hCOMMA	},	/* right */
		{ (natural_t) &hSMUDGE	},	/* hide */
		{ (natural_t) &hFOREMK	},
		{ (natural_t) &hDROOT	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hPINSTA	},	/* in vocab */
		{ (natural_t) &hSEMIS	}
	}
};


/*
01500 	FCC 'CONSTANT'
01510 	FCB 8
01520 	FCB MFORE
01530 	FDB CREATE-CFAOFF
01540 	FDB BIF+2
01550 	FDB CMOVE-CFAOFF
01560 	FDB CREATE-CFAOFF
*/
static character_t sCONST[] = "\x8" "CONSTANT";
definition_header_s hCONST = 
{	{ (natural_t) sCONST },
	{ 0 },
	{ (natural_t) &hCREATE },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hCMOVE },
	{ (natural_t) &hCREATE },
	{ (natural_t) XCOL },
/*
01570 CONST	DOCOL
01580 	FDB CREATE
01590 	FDB IPCOM
01600 	DOCON
01610 	FDB COMMA
01620 	FDB SMUDGE visible
01630 	FDB SEMIS
01690 *
*/
	{
		{ (natural_t) &hCREATE	},
		{ (natural_t) &hIPCOM	},
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hSMUDGE	},	/* visible */
		{ (natural_t) &hSEMIS	}
	}
};
/*
01700 	FCC 'VARIABLE'
01710 	FCB 8
01720 	FCB MFORE
01730 	FDB CONST-CFAOFF
01740 	FDB BIF+2
01750 	FDB USTAR-CFAOFF
01760 	FDB WORD-CFAOFF
*/
static character_t sVAR[] = "\x8" "VARIABLE";
definition_header_s hVAR = 
{	{ (natural_t) sVAR },
	{ 0 },
	{ (natural_t) &hCONST },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hUSTAR },
	{ (natural_t) &hWHILE },
	{ (natural_t) XCOL },
/*
01770 VAR	DOCOL
01780 	FDB CREATE
01790 	FDB IPCOM
01800 	DOVAR
01810 	FDB COMMA initial value
01820 	FDB SMUDGE visible
01830 	FDB SEMIS
01890 *
*/
	{
		{ (natural_t) &hCREATE	},
		{ (natural_t) &hIPCOM	},
		{ (natural_t) &hCOMMA	},	/* initial value */
		{ (natural_t) &hSMUDGE	},	/* visible */
		{ (natural_t) &hSEMIS	}
	}
};
/*
01900 	FCC 'USER'
01910 	FCB 4
01920 	FCB MFORE
01930 	FDB VAR-CFAOFF
01940 	FDB BIF+2
01950 	FDB USE-CFAOFF
01960 	FDB UTIL-CFAOFF
*/
static character_t sUSER[] = "\x4" "USER";
definition_header_s hUSER = 
{	{ (natural_t) sUSER },
	{ 0 },
	{ (natural_t) &hVAR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hUSE },
	{ (natural_t) &hUTIL },
	{ (natural_t) XCOL },
/*
01970 USER	DOCOL
01980 	FDB CREATE
01990 	FDB IPCOM
02000 	DOUSER
02010 	FDB CCOMMA offset
02020 	FDB SMUDGE visible
02030 	FDB SEMIS
02080 *
*/
	{
		{ (natural_t) &hCREATE	},
		{ (natural_t) &hIPCOM	},
		{ (natural_t) &hCCOMMA	},	/* offset */
		{ (natural_t) &hSMUDGE	},	/* visible */
		{ (natural_t) &hSEMIS	},
	}
};
/*
02090 SCOMP	EQU MCOMP.OR.MIMM
02100 	FCC ':'
02110 	FCB MIMM.OR.1
02120 	FCB MFORE
02130 	FDB USER-CFAOFF
02140 	FDB BIF+2
02150 	FDB ADD-CFAOFF
02160 	FDB FETCH-CFAOFF
*/
static character_t sCOLON[] = "\x1" ":";
definition_header_s hCOLON = 
{	{ (natural_t) sCOLON },
	{ MIMM },
	{ (natural_t) &hUSER },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hADD },
	{ (natural_t) &hFETCH },
	{ (natural_t) XCOL },
/*
02170 COLON	DOCOL
02180 	FDB QEXEC
02190 	FDB STOCSP
02200 	FDB CREATE
02210 	FDB IPCOM
02220 	DOCOL
02230 	FDB RBRAK
02240 	FDB SEMIS
02290 *
*/
	{
		{ (natural_t) &hQEXEC	},
		{ (natural_t) &hSTOCSP	},
		{ (natural_t) &hCREATE	},
		{ (natural_t) &hIPCOM	},
		{ (natural_t) &hRBRAK	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
02300 	FCC ';'
02310 	FCB MIMM.OR.1
02320 	FCB MFORE
02330 	FDB COLON-CFAOFF
02340 	FDB BIF+2
02350 	FDB 0
02360 	FDB 0
*/
static character_t sSEMI[] = "\x1" ";";
definition_header_s hSEMI = 
{	{ (natural_t) sSEMI },
	{ MIMM },
	{ (natural_t) &hCOLON },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
02370 SEMI	DOCOL	see fig-FORTH model
02380 	FDB QCSP
02390 	FDB COMP
02400 	FDB SEMIS
02410 	FDB SMUDGE
02420 	FDB LBRAK
02430 	FDB SEMIS
02490 *
*/
	{
		{ (natural_t) &hQCSP	},
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hSEMIS	},
		{ (natural_t) &hSMUDGE	},
		{ (natural_t) &hLBRAK	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
02500 	FCC '."'
02510 	FCB MIMM.OR.2
02520 	FCB MFORE
02530 	FDB SEMI-CFAOFF
02540 	FDB BIF+2
02550 	FDB 0
02560 	FDB 0
*/
static character_t sDOTQ[] = "\x2" ".\"";
definition_header_s hDOTQ = 
{	{ (natural_t) sDOTQ },
	{ MIMM },
	{ (natural_t) &hSEMI },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
02570 DOTQ	DOCOL
02572 	FDB ONE past delimiter
02574 	FDB IN
02576 	FDB ADDSTO
02580 	FDB LIT
02590 	FDB '"
02600 	FDB WORD
02610 	FDB WORDPD
02620 	FDB QCST
02630 	FDB ZBR
02640 	FDB DOTQT-*-2
02650 	FDB COMP
02660 	FDB XDOTQ
02670 	FDB HERE
02680 	FDB OVER
02690 	FDB CFEH count
02700 	FDB ADD1
02710 	FDB DUP
02720 	FDB ALLOT
02730 	FDB CMOVE
02732 	FDB ONE past end quote
02734 	FDB IN
02736 	FDB ADDSTO
02740 	FDB BRANCH
02750 	FDB 4
02760 DOTQT	FDB COUNT
02770 	FDB TYPE
02780 	FDB SEMIS
02790 *
*/
	{
		{ (natural_t) &hONE	},	/* past delimiter */
		{ (natural_t) &hIN	},
		{ (natural_t) &hADDSTO	},
		{ (natural_t) &hLIT	},
		{ (natural_t) '"'	},
		{ (natural_t) &hWORD	},
		{ (natural_t) &hWORDPD	},
		{ (natural_t) &hQCST	},
		{ (natural_t) &hZBR	},
		{ (natural_t) 14 * sizeof (cell_u)	},	/* &hDOTQT-*-2 */
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hXDOTQ	},
		{ (natural_t) &hHERE	},
		{ (natural_t) &hOVER	},
		{ (natural_t) &hCFEH	},	/* count */

/* **************** MUST add code to pad to word boundary! **************** */

		{ (natural_t) &hADD1	},
		{ (natural_t) &hDUP	},
		{ (natural_t) &hALLOT	},
		{ (natural_t) &hCMOVE	},
		{ (natural_t) &hONE	},	/* past end quote */
		{ (natural_t) &hIN	},
		{ (natural_t) &hADDSTO	},
		{ (natural_t) &hBRANCH	},
		{ (natural_t) 2 * sizeof (cell_u)	},	/* 4 */
/* DOTQT: */
		{ (natural_t) &hCOUNT	},
		{ (natural_t) &hTYPE	},
		{ (natural_t) &hSEMIS	},
	}
};


/*
02800 	FCC '[COMPILE]'
02810 	FCB MIMM.OR.9
02820 	FCB MFORE
02830 	FDB DOTQ-CFAOFF
02840 	FDB BIF+2
02850 	FDB LBRAK-CFAOFF
02860 	FDB RBRAK-CFAOFF
*/
static character_t sBCOMP[] = "\x9" "[COMPILE]";
definition_header_s hBCOMP = 
{	{ (natural_t) sBCOMP },
	{ MIMM },
	{ (natural_t) &hDOTQ },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hLBRAK },
	{ (natural_t) &hRBRAK },
	{ (natural_t) XCOL },
/*
02870 BCOMP	DOCOL
02880 	FDB DDFIND
02890 	FDB DROP vocab
02900 	FDB DUP
02910 	FDB ZEQ
02920 	FDB ZERO
02930 	FDB QERR
02940 	FDB CFA
02950 	FDB COMMA
02960 	FDB SEMIS
03180 *
*/
	{
		{ (natural_t) &hDDFIND	},
		{ (natural_t) &hDROP	},	/* vocab */
		{ (natural_t) &hDUP	},
		{ (natural_t) &hZEQ	},
		{ (natural_t) &hZERO	},
		{ (natural_t) &hQERR	},
		{ (natural_t) &hCFA	},
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hSEMIS	},
	}
};


/*
03200 	FCC 'INTERPRET'
03210 	FCB 9
03220 	FCB MFORE
03230 	FDB BCOMP-CFAOFF
03240 	FDB BIF+2
03250 	FDB 0 * INDEX-CFAOFF
03260 	FDB J-CFAOFF
*/
static character_t sINTERP[] = "\x9" "INTERPRET";
definition_header_s hINTERP = 
{	{ (natural_t) sINTERP },
	{ 0 },
	{ (natural_t) &hBCOMP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },	/* INDEX-CFAOFF ??? */
	{ (natural_t) &hJ },
	{ (natural_t) XCOL },
/*
03270 INTERP	DOCOL
03280 	FDB DIFIND
03290 	FDB DROP
03300 	FDB DDUP
03310 	FDB ZBR
03320 	FDB INTERN-*-2
03330 	FDB DUP
03340 	FDB CFA
03350 	FDB SWAP
03360 	FDB CFEH length
03370 	FDB DUP
03380 	FDB NOT
03390 	FDB LIT
03400 	FDB MIMM
03410 	FDB AND
03420 	FDB QCST
03430 	FDB AND
03440 	FDB ZBR
03450 	FDB INTERX-*-2
03460 	FDB DROP length
03470 	FDB COMMA
03480 	FDB BRANCH
03490 	FDB INTERE-*-2
03500 INTERX	FDB LIT
03510 	FDB MCOMP
03520 	FDB AND
03530 	FDB QCST
03540 	FDB NOT
03550 	FDB AND
03560 	FDB LIT
03570 	FDB $11
03580 	FDB QERR
03590 	FDB EXEC
03600 	FDB BRANCH
03610 	FDB INTERE-*-2
03620 INTERN	FDB WORDPD
03630 	FDB NUMBER
03640 	FDB DPL
03645 	FDB FETCH
03650 	FDB ZLESS
03660 	FDB ZBR
03670 	FDB INTERE-*-4
03680 	FDB DROP
03690 	FDB LITER
03700 	FDB BRANCH
03710 	FDB INTERE-*-2
03720 	FDB DLITER
03730 INTERE	FDB QSTACK
03740 	FDB BRANCH
03750 	FDB INTERP-*
03790 *
*/
	{
		{ (natural_t) &hDIFIND	},
		{ (natural_t) &hDROP	},
		{ (natural_t) &hDDUP	},
		{ (natural_t) &hZBR	},
		{ 29 * sizeof (cell_u)	},	/* INTERN-*-2 */
		{ (natural_t) &hDUP	},
		{ (natural_t) &hCFA	},
		{ (natural_t) &hSWAP	},
		{ (natural_t) &hIMFA	},	/* length, NO, the interpret mode bits! */
		{ (natural_t) &hFETCH	},	/* (And more exercises in symbol table maintenance.) */
		{ (natural_t) &hDUP	},
		{ (natural_t) &hNOT	},
		{ (natural_t) &hLIT	},
		{ MIMM	},
		{ (natural_t) &hAND	},
		{ (natural_t) &hQCST	},
		{ (natural_t) &hAND	},
		{ (natural_t) &hZBR	},
		{ 4 * sizeof (cell_u)	},	/* INTERX-*-2 */
		{ (natural_t) &hDROP	},	/* length */
		{ (natural_t) &hCOMMA	},
		{ (natural_t) &hBRANCH	},
		{ 24 * sizeof (cell_u)	},	/* INTERE-*-2 */
/* INTERX: */
		{ (natural_t) &hLIT	},
		{ MCOMP	},
		{ (natural_t) &hAND	},
		{ (natural_t) &hQCST	},
		{ (natural_t) &hNOT	},
		{ (natural_t) &hAND	},
		{ (natural_t) &hLIT	},
		{ 0x11	},	/* mode bits, but what are they? */
		{ (natural_t) &hQERR	},
		{ (natural_t) &hEXEC	},
		{ (natural_t) &hBRANCH	},
		{ 12 * sizeof (cell_u)	},	/* INTERE-*-2 */
/* INTERN: */
		{ (natural_t) &hWORDPD	},
		{ (natural_t) &hNUMBER	},
		{ (natural_t) &hDPL	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hZLESS	},
		{ (natural_t) &hZBR	},
		{ 4 * sizeof (cell_u)	},	/* INTERE-*-4 */
		{ (natural_t) &hDROP	},
		{ (natural_t) &hLITER	},
		{ (natural_t) &hBRANCH	},
		{ 1 * sizeof (cell_u)	},	/* INTERE-*-2 */
		{ (natural_t) &hDLITER	},
/* INTERE: */
		{ (natural_t) &hQSTACK	},
		{ (natural_t) &hBRANCH	},
		{ -49 * sizeof (cell_u)	}	/* INTERP-* */
	}
};

jmp_buf quitBuffer;
static character_t sOK_PROMPT[] = "\x3" " OK";
/*
04200 	FCC 'QUIT'
04210 	FCB 4
04220 	FCB MFORE
04230 	FDB INTERP-CFAOFF
04240 	FDB BIF+2
04250 	FDB 0
04260 	FDB 0
*/
static character_t sQUIT[] = "\x4" "QUIT";
definition_header_s hQUIT = 
{	{ (natural_t) sQUIT },
	{ 0 },
	{ (natural_t) &hINTERP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) QUIT }
/*
	{ (natural_t) XCOL },
04270 QUIT	DOCOL	see fig-FORTH model
04280 	FDB ZERO
04290 	FDB BLK
04300 	FDB STORE
04310 	FDB LBRAK
04320 QUITL	FDB TNULL
04325 	FDB RPSTO
04330 	FDB CR
04340 	FDB QUERY
04350 	FDB INTERP
04360 	FDB QCST
04370 	FDB TBR
04380 	FDB QUITL-*-2
04390 	FDB XDOTQ
04400 	FCB 3
04410 	FCC ' OK'
04420 	FDB BRANCH
04430 	FDB QUITL-*-2
04490 *
	{
		{ (natural_t) &hZERO	},
		{ (natural_t) &hBLK	},
		{ (natural_t) &hSTORE	},
		{ (natural_t) &hLBRAK	},
// * QUITL: * /
		{ (natural_t) &hTNULL	},	// * This can call ERROR on some machines, so no setjmp() after here. * /
		{ (natural_t) &hRPSTO	},
		{ (natural_t) &hCR	},
		{ (natural_t) &hQUERY	},
		{ (natural_t) &hINTERP	},
		{ (natural_t) &hQCST	},
		{ (natural_t) &hTBR	},
		{ -8 * sizeof (cell_u)	},	// * QUITL-*-2 * /
// *		{ (natural_t) &hXDOTQ	},
	 	{ '0x3 OK'	},
* /
		{ (natural_t) &hLIT	},
		{ (natural_t) sOK_PROMPT	},
		{ (natural_t) &hCOUNT	},
		{ (natural_t) &hTYPE	},
		{ (natural_t) &hBRANCH	},
		{ -14 * sizeof (cell_u)	}	// * QUITL-*-2 * /
	}
*/
};
void QUIT( void)
{	longjmp( quitBuffer, QUIT_JMP_FLAG );
}
static character_t sPHQUIT[] = "\x7" "(HQUIT)";
definition_header_s hPHQUIT = 
{	{ (natural_t) sPHQUIT },
	{ MHID },
	{ (natural_t) &hQUIT },
	{ MFORE },
	{ (natural_t) &hUTIL },
	{ 0 },
	{ 0 },
	{ (natural_t) PHQUIT }
};
void PHQUIT(void)
{
	/* I want to hide these, so that I can test the return value meaningfully. */
	setjmp( quitBuffer );	/* Do we care whether we came here via ABORT or longjmp() ? You've 'eard it b'fore */
	UP.task->activeDiscBlock.integer = 0L;
	LBRAK();
	for ( ;; )
	{
		TNULL();	/* This can call ERROR on some machines, so no setjmp() after here. */
		RPSTO();
		CR();
		QUERY();
		mCALLdef( hINTERP );	/* Doesn't execute before returning unless DOCOL executes a NEXT loop. */
		QCST();
		if ( ( * --SP ).integer == 0 )
		{	
			( * --SP ).bytep = sOK_PROMPT;
			COUNT();
			TYPE();
		}
	}
}


/* Notes on stuff that doesn't work for embedded strings:
	{	{ (natural_t) &hTYPE	},
		{ (natural_t) { 3, ' ', 'O', 'K' }  }, // Only the 3 is compiled in, gets an "excess elements" warning.
		{ (natural_t) ( (packed_cell_a) { 'A', 'R', 'R' } ) }, // These are compiled as pointers to arrays,
		{ (natural_t) ( (packed_cell_a) { 'O', 'N' } ) }, // the arrays being compiled elsewhere.
		{ (natural_t) ( (packed_cell_a) { 'p', 'e', 'a', 'k' } ) },
		{ (natural_t) ( (packed_cell_a) { '?' } ) },
		{ (natural_t) &hBIF	},
		{ (natural_t) &hVLIST	}
	}
*/
