/*
**  bif4b_a.c
**  bif-c
**
**  Created by Joel Rees on 2009/08/16.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF4B/A, as mechanically as possible.
*/


#include "bif_m.h"

#include "bif7b_a.h"	/* To link into the BIF vocabulary. */

#include "bif5b_a.h"	/* for ERROR */

#include "bif4b_a.h"


/*
00010 * Include file for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00030 *
05010 	FCC '?ERROR'
05020 	FCB 6
05030 	FCB MFORE
05040 	FDB RW-CFAOFF
05050 	FDB BIF+2
05060 	FDB 0
05070 	FDB 0
*/
static character_t sQERR[] = "\x6" "?ERROR";
definition_header_s hQERR =	
{	{ (natural_t) sQERR },
	{ 0 },
	{ (natural_t) &hRW },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) QERR }
};
/*
05080 QERR	PULU X
05090 	LDD ,U++
05100 	BNE *+4
05110 	NEXT
05120 	PSHU X
05130 	JMP ERROR
05200 *
*/
void QERR(void)
{	natural_t messageNumber = ( * SP++ ).integer;
	if ( ( * SP++ ).integer != 0 )
	{	mERROR( messageNumber );
	}
}


/*
05210 	FCC '?COMP'
05220 	FCB 5
05230 	FCB MFORE
05240 	FDB QERR-CFAOFF
05250 	FDB BIF+2
05260 	FDB TOR-CFAOFF
05270 	FDB QEXEC-CFAOFF
*/
static character_t sQCOMP[] = "\x5" "?COMP";
definition_header_s hQCOMP = 
{	{ (natural_t) sQCOMP },
	{ 0 },
	{ (natural_t) &hQERR },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hTOR },
	{ (natural_t) &hQEXEC },
	{ (natural_t) QCOMP }
};
/*
05280 QCOMP	LDX <UP
05290 	LDB USTATE+1,X
05300 	ANDB #SCOMP
05310 	BNE QPAIRN	// What was I thinking?
05320 	LDD #$11
05330 	BRA QPAIRE
05400 *
*/
void QCOMP( void )
{	if ( ( UP.task->compilerState.integer & SCOMP ) == 0 )
	{	mERROR( COMPILATION_ONLY_USE_IN_DEF );	/* Not the QPAIRS entry point, but it would be the same macro anyway. */
	}
}


/*
05410 	FCC '?EXEC'
05420 	FCB 5
05430 	FCB MFORE
05440 	FDB QCOMP-CFAOFF
05450 	FDB BIF+2
05460 	FDB QCST-CFAOFF
05470 	FDB QPAIRS-CFAOFF
*/
static character_t sQEXEC[] = "\x5" "?EXEC";
definition_header_s hQEXEC = 
{	{ (natural_t) sQEXEC },
	{ 0 },
	{ (natural_t) &hQCOMP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hQCST },
	{ (natural_t) &hQPAIRS },
	{ (natural_t) QEXEC }
};
/*
05480 QEXEC	LDX <UP
05490 	LDB USTATE+1,X
05500 	BEQ QPAIRN
05510 	LDD #$12
05520 	BRA QPAIRE
05600 *
*/
void QEXEC( void )
{	if ( UP.task->compilerState.integer != 0 )
	{	mERROR( EXECUTION_ONLY );
	}
}


/*
05610 	FCC '?PAIRS'
05620 	FCB 6
05630 	FCB MFORE
05640 	FDB QEXEC-CFAOFF
05650 	FDB BIF+2
05660 	FDB QLOAD-CFAOFF
05670 	FDB QTERM-CFAOFF
*/
static character_t sQPAIRS[] = "\x6" "?PAIRS";
definition_header_s hQPAIRS = 
{	{ (natural_t) sQPAIRS },
	{ 0 },
	{ (natural_t) &hQEXEC },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hQLOAD },
	{ (natural_t) &hQTERM },
	{ (natural_t) QPAIRS }
};
/*
05680 QPAIRS	PULU D
05690 	SUBD ,U++
05700 	BEQ QPAIRN
05710 	LDD #$13
05720 QPAIRE	PSHU D robbed
05730 	JMP ERROR
05740 QPAIRN	NEXT robbed
05800 *
*/
void QPAIRS( void )
{	byte_t * pairHalf = ( * SP++ ).bytep;
	if ( pairHalf != ( * SP++ ).bytep )
	{	mERROR( CONDITIONALS_NOT_PAIRED );
	}
}


/*
05810 	FCC '?CSP'
05820 	FCB 4
05830 	FCB MFORE
05840 	FDB QPAIRS-CFAOFF
05850 	FDB BIF+2
05860 	FDB 0
05870 	FDB 0
*/
static character_t sQCSP[] = "\x4" "?CSP";
definition_header_s hQCSP = 
{	{ (natural_t) sQCSP },
	{ 0 },
	{ (natural_t) &hQPAIRS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) QCSP }
};
/*
05880 QCSP	LDX <UP
05890 	TFR U,D
05900 	SUBD UCSP,X
05910 	BEQ QPAIRN
05920 	LDD #$14
05930 	BRA QPAIRE
06000 *
*/
void QCSP( void )
{	if ( SP != UP.task->compilerStackMarker.cellp )
	{	mERROR( DEFINITION_INCOMPLETE );
	}
}


/*
06010 	FCC '?LOADING'
06020 	FCB 8
06030 	FCB MFORE
06040 	FDB QCSP-CFAOFF
06050 	FDB BIF+2
06060 	FDB 0
06070 	FDB 0
*/
static character_t sQLOAD[] = "\x8" "?LOADING";
definition_header_s hQLOAD =	
{	{ (natural_t) sQLOAD },
	{ 0 },
	{ (natural_t) &hQCSP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) QLOAD }
};
/*
06080 QLOAD	LDX <UP
06090 	LDD UBLK,X
06100 	BNE QPAIRN
06110 	LDD #$16
06120 	BRA QPAIRE
06200 *
05720 QPAIRE	PSHU D robbed
05730 	JMP ERROR
05740 QPAIRN	NEXT robbed
*/
void QLOAD(void)
{
	if ( UP.task->activeDiscBlock.integer == 0 )
	{	mERROR( USE_ONLY_WHEN_LOADING );
	}
}


/*
06210 	FCC 'COMPILE'
06220 	FCB 7
06230 	FCB MFORE
06240 	FDB QLOAD-CFAOFF
06250 	FDB BIF+2
06260 	FDB COLD-CFAOFF
06270 	FDB COMPO-CFAOFF
*/
static character_t sCOMP[] = "\x7" "COMPILE";
definition_header_s hCOMP = 
{	{ (natural_t) sCOMP },
	{ 0 },
	{ (natural_t) &hQLOAD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hCOLD },
	{ (natural_t) &hCOMPO },
	{ (natural_t) COMP },
};
/*
06280 COMP	DOCOL
06290 	FDB QCOMP
06300 	FDB XMACH
06310 COMPIP	LDD ,Y++ robbed by IP,
06320 	PSHU D
06330 	JMP COMMA
06390 *
*/
void COMP(void)
{	QCOMP();
	IPCOM();	/* Reverse the steal */
}


/*
06410 	FCC 'LOOP'
06420 	FCB MIMM.OR.MCOMP.OR.4
06430 	FCB MFORE
06440 	FDB COMP-CFAOFF
06450 	FDB BIF+2
06460 	FDB KEY-CFAOFF
06470 	FDB NUMBER-CFAOFF
*/
static character_t sLOOP[] = "\x4" "LOOP";
definition_header_s hLOOP = 
{	{ (natural_t) sLOOP },
	{ MIMM | MCOMP },
	{ (natural_t) &hCOMP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hKEY },
	{ (natural_t) &hNUMBER },
	{ (natural_t) XCOL },
/*
06480 LOOP	DOCOL	see fig-FORTH model
06490 	FDB LIT
06500 	FDB ('D)*256+'O
06510 	FDB QPAIRS
06520 	FDB COMP
06530 	FDB XLOOP
06540 	FDB BACK
06550 	FDB SEMIS
06590 *
*/
	{
		{ (natural_t) &hLIT	},
		{ LOOP_FLAG	},
		{ (natural_t) &hQPAIRS	},
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hXLOOP	},
		{ (natural_t) &hBACK	},
		{ (natural_t) &hSEMIS	}
	}
};


/*
06610 	FCC '+LOOP'
06620 	FCB MIMM.OR.MCOMP.OR.5
06630 	FCB MFORE
06640 	FDB LOOP-CFAOFF
06650 	FDB BIF+2
06660 	FDB CHS-CFAOFF
06670 	FDB COMMA-CFAOFF
*/
static character_t sPLOOP[] = "\x5" "+LOOP";
definition_header_s hPLOOP = 
{	{ (natural_t) sPLOOP },
	{ MIMM | MCOMP },
	{ (natural_t) &hLOOP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hCHS },
	{ (natural_t) &hCOMMA },
	{ (natural_t) XCOL },
/*
06680 PLOOP	DOCOL	see fig-FORTH model
06690 	FDB LIT
06700 	FDB ('D)*256+'O
06710 	FDB QPAIRS
06720 	FDB COMP
06730 	FDB XPLOOP
06740 	FDB BACK
06750 	FDB SEMIS
06790 *
*/
	{
		{ (natural_t) &hLIT	},
		{ LOOP_FLAG	},
		{ (natural_t) &hQPAIRS	},
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hXPLOOP	},
		{ (natural_t) &hBACK	},
		{ (natural_t) &hSEMIS	},
	}
};


/*
06809 	FCC 'LOAD'
06820 	FCB 4
06830 	FCB MFORE
06840 	FDB PLOOP-CFAOFF
06850 	FDB BIF+2
06860 	FDB 0
06870 	FDB 0
*/
static character_t sLOAD[] = "\x4" "LOAD";
definition_header_s hLOAD = 
{	{ (natural_t) sLOAD },
	{ 0 },
	{ (natural_t) &hPLOOP },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hLMFA },
	{ 0 },
	{ (natural_t) LOAD }
/*	{ (natural_t) XCOL },
	{
		{ (natural_t) &hBLK	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hTOR	},
		{ (natural_t) &hIN	},
		{ (natural_t) &hFETCH	},
		{ (natural_t) &hTOR	},
		{ (natural_t) &hZERO	},
		{ (natural_t) &hIN	},
		{ (natural_t) &hSTORE	},
		{ (natural_t) &hBPSCR	},
		{ (natural_t) &hSTAR	},
		{ (natural_t) &hBLK	},
		{ (natural_t) &hSTORE	},
		{ (natural_t) &hINTERP	},
		{ (natural_t) &hRFROM	},
		{ (natural_t) &hIN	},
		{ (natural_t) &hSTORE	},
		{ (natural_t) &hRFROM	},
		{ (natural_t) &hBLK	},
		{ (natural_t) &hSTORE	},
		{ (natural_t) &hSEMIS	}
	}
*/
};
/*
06880 LOAD	PSHS Y	see fig-FORTH model
06890 	LDY <UP
06900 	LDD UIN,Y
06910 	LDX UBLK,Y
06920 	PSHS X,D
06930 	LDD #0
06940 	STD UIN,Y
06950 	DOCOL
06960 	FDB BPSCR
06970 	FDB STAR
06980 	FDB BLK
06990 	FDB STORE
07000 	FDB INTERP
07010 	FDB XMACH
07020 	PULS D,X
07030 	STD UIN,Y
07040 	STX UBLK,Y
07050 	PULS Y
07060 	NEXT
07090 *
*/
void LOAD( void )
{	* --RP = UP.task->activeDiscBlock;
	* --RP = UP.task->bufferInputOffset;
#if defined DBG_WORD_PARSE
	fprintf( standardError, "LOADing interrupts block %p at %lu for block %lu\n", 
			 UP.task->activeDiscBlock.bytep, (unsigned long) UP.task->bufferInputOffset.integer, 
			 (unsigned long) SP[ 0 ].integer * hBPSCR.parameterLink[ 0 ].integer );
#endif
	UP.task->bufferInputOffset.integer = 0;
	UP.task->activeDiscBlock.integer = ( * SP++ ).integer * hBPSCR.parameterLink[ 0 ].integer;
	mCALLdef( hINTERP );	/* Will it work? */
	UP.task->bufferInputOffset = * RP++;
	UP.task->activeDiscBlock = * RP++;
#if defined DBG_WORD_PARSE
	fprintf( standardError, "Restored block %p at %lu after LOAD.\n", 
			 UP.task->activeDiscBlock.bytep, UP.task->bufferInputOffset.integer );
#endif
}


/*
07110 	FCC '<BUILDS'
07120 	FCB MCOMP.OR.7
07130 	FCB MFORE
07140 	FDB LOAD-CFAOFF
07150 	FDB BIF+2
07160 	FDB 0
07170 	FDB 0
*/
static character_t sBUILDS[] = "\x7" "<BUILDS";
definition_header_s hBUILDS = 
{	{ (natural_t) sBUILDS },
	{ MCOMP },
	{ (natural_t) &hLOAD },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) XCOL },
/*
07180 BUILDS	DOCOL	see fig-FORTH model
07190 	FDB ZERO
07200 	FDB CONST
07210 	FDB SEMIS
07290 *
*/
	{
		{ (natural_t) &hZERO	},
		{ (natural_t) &hCONST	},
		{ (natural_t) &hSEMIS	},
	}
};
/*
07310 	FCC 'DOES>'
07320 	FCB MCOMP.OR.5
07330 	FCB MFORE
07340 	FDB BUILDS-CFAOFF
07350 	FDB BIF+2
07360 	FDB 0
07370 	FDB 0
*/
static character_t sDOES[] = "\x5" "DOES>";
definition_header_s hDOES = 
{	{ (natural_t) sDOES },
	{ MCOMP },
	{ (natural_t) &hBUILDS },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ 0 },
	{ 0 },
	{ (natural_t) DOES }
};
/*
07380 DOES	LDX <UP
07430 	LDX UCURR,X
07440 	LDD ADOES,PCR
07450 	STD CFAOFF,X
07460 	STY PFAOFF,X
07470 	PULS Y
07480 	NEXT
07490 ADOES	JSR <XDOES
07790 *
*/
void DOES( void )
{	definition_header_s * underConstruction = ( UP.task->lastDefined ).definitionp;
	underConstruction->codeLink.icode = XDOES;
	underConstruction->parameterLink[ 0 ].cellp = IP;	/* Not a good idea until we can assemble actual code. */
	/* IP = ( * RP++ ).cellp; // Don't really feel confident about this. */
	if ( sysSIG.integer == ICODE_LIST_CONTINUE )
	{	sysSIG.integer = ICODE_LIST_END;
	}	
}


/*
07810 	FCC ';CODE'
07820 	FCB MCOMP.OR.MIMM.OR.5
07830 	FCB MFORE
07840 	FDB DOES-CFAOFF
07850 	FDB BIF+2
07860 	FDB SEMI-CFAOFF
07870 	FDB SEMIS-CFAOFF
*/
static character_t sSCODE[] = "\x5" ";CODE";	/* Have to mark this not avaiable. */
definition_header_s hSCODE = 
{	{ (natural_t) sSCODE },
	{ MCOMP | MIMM },
	{ (natural_t) &hDOES },
	{ MFORE },
	{ (natural_t) &hBIF },
	{ (natural_t) &hSEMI },
	{ (natural_t) &hSEMIS },
	{ (natural_t) XCOL },
/*
07880 SCODE	DOCOL	not fig
07890 	FDB QCSP
07900 	FDB COMP
07910 	FDB XSCODE
07915 	FDB LBRAK
07920 	FDB ASMBLR
07930 	FDB STOCSP	to check later
07940 	FDB SEMIS
07950 * something else must SMUDGE
07960 *
*/
	{
		{ (natural_t) &hQCSP	},
		{ (natural_t) &hCOMP	},
		{ (natural_t) &hXSCODE	},
		{ (natural_t) &hLBRAK	},
		{ (natural_t) &hASMBLR	},
		{ (natural_t) &hSTOCSP	},	/* to check later */
		{ (natural_t) &hSEMIS	}
	}
};
