/*
**  bifu_a.h
**  bif-c
**
**  Created by Joel Rees on 2009/07/22.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIF/A, as mechanically as possible.
*/


#if !defined BIF_A_H
#define BIF_A_H


#include "bifu_i.h"


extern definition_header_s hFETCH;
extern void FETCH(void);

extern definition_header_s hSTORE;
extern void STORE(void);

extern definition_header_s hLIT;
extern void LIT(void);

extern definition_header_s hDLIT;
extern void DLIT(void);

#define mCALLcell( cell )	( ( * ( W = cell ).definitionp ).codeLink.icode )()
#define mCALLdefp( headerp )	( ( * ( W.definitionp = headerp ) ).codeLink.icode )()
#define mCALLdef( header )	mCALLdefp( &header )

extern definition_header_s hEXEC;
extern void EXEC(void);
/* Doesn't really make sense to go to the extra effort of calling EXEC, 
** and then there is the recursion problem when EXEC calls ERROR.
** On the other hand, if we don't know whether we are trying to call out to NULL pointers, these might be useful.
** If so, I'll un-comment them. 
#define	mEXECdef( def )	\
{	( * --SP ).definitionp = def;	\
	EXEC();	\
}
#define	mEXECcell( defdell )	\
{	( * --SP ).definitionp = defcell.definitionp;	\
	EXEC();	\
}
*/

extern definition_header_s hTBR;
extern void TBR(void);

extern definition_header_s hBRANCH;
extern void BRANCH(void);

extern definition_header_s hZBR;
extern void ZBR(void);

extern definition_header_s hXLOOP;
extern void XLOOP(void);

extern definition_header_s hXPLOOP;
extern void XPLOOP(void);

extern definition_header_s hXDO;
extern void XDO(void);

extern definition_header_s hI;
extern void I(void);

extern definition_header_s hJ;
extern void J(void);

extern definition_header_s hDIGIT;
extern void DIGIT(void);

extern definition_header_s hPFIND;
extern void PFIND(void);

extern definition_header_s hENCLOS;
extern void ENCLOS(void);

extern definition_header_s hLITER;
extern void LITER(void);

extern definition_header_s hDLITER;
extern void DLITER(void);


#endif /* !defined BIF_A_H */
