/*
**  bifu_inc.h
**  bif-c
**
**  Created by Joel Rees on 2009/07/21.
**  Copyright 2009 __Reiisi_Kenkyuu__. All rights reserved.
**
** Translated to C from BIFU/I, as mechanically as possible.
*/


#if !defined BIFU_I_H
#define BIFU_I_H


#include <limits.h>
#include <stdio.h>	/* erk. */



#include "tools_g00.h"


/* #include "biftypes.h" */


#define	DEBUGGING	0x10	/* So I can build some stub stuff to test the most basic stuff. */
/* 1 is for DOCOL (starting a colon definition), DOVAR, etc. However, ... */
/* #define	DBG_BOOTSTRAP_TESTING */
/* #define DBG_FUNCTIONAL_TESTING */
/* #define	DBG_SHOW_SYMBOL_TABLE */
#define	DBG_TRACE_NEXT 
/* #define	DBG_FIND */
/* #define	DBG_NUMBER_PARSE */
/* #define	DBG_WORD_PARSE  */
/* #define	DBG_DEFINING_WORDS */


/* #define btdbg_printf fprintf */
/* Can't just undefine it because of the parameters problem. Parameter count must match in definition and call! 
// Guess I'll have to define a function and use the variable parameters stuff, to do it. 
// Or just bury the debug stuff in #ifdef -- #endif blocks.
*/

/*
00010 * USER variable definitions for BIF
00020 * BIF Copyright 1989 Joel Matthew Rees (see BIF/ASM)
00100 * INCLUDE THIS BEFORE SETTING DPR
00110 * ORG used here for offsets only
*/

/* Need some typedefs to describe things like the natural integer:
**
** If you want something else, edit celltype.c/h or makecelltype.c.
** But be prepared for strangeness.
*/
#include "configs/celltype.h"


/* What I want here is to define dblnatural_t appropriately for the architecture.
// If C provides a long long, I want to use that.
// Hopefully, the long long C provides will be both optimal 
// and in keeping with the proper byte order for the CPU.
// (Not attempting to deal with VAX order at this point.)
		typedef unsigned long long dblnatural_t;
		typedef signed long long sdblnatural_t;
#		define	DOUBLE_BITS	64
*/



#if !defined BITSPERBYTE || ( BITSPERBYTE != CHAR_BIT )
#	error "**** STOP NOW!!!! ****"
#	error "cd config; make clean; make; cd .."
#	error "before continuing!"
#endif


/* Should use the types, limits, and constants  
** defined in ** celltype.h ** instead. 
*/

#define	UCHAR_MAX_AVAILABLE	BITSPERBYTE
#define	UCHAR_HIGH_BIT	BYTE_HIGH_BIT

#define	USHRT_MAX_AVAILABLE	BITSPERSHORTW
#define	USHRT_HIGH_BIT	SHORTW_HIGH_BIT

#define	ULONG_MAX_AVAILABLE	BITSPERLONGW
#define	ULONG_HIGH_BIT	LONGW_HIGH_BIT

#define	ULONG_LONG_MAX_AVAILABLE	BITSPERLLONGW
#define	ULONG_LONG_HIGH_BIT	LLONGW_HIGH_BIT

#define	UINT_MAX_AVAILABLE	BITSPERINTW
#define	UINT_HIGH_BIT	INTW_HIGH_BIT


/* These are the constants and types that bif-c 
** will actually use.
*/


#define BITSPERSHRT		USHRT_MAX_AVAILABLE
#define	BYTESPERSHRT		( BITSPERSHRT / BITSPERBYTE )
#define BITSPERLONG		ULONG_MAX_AVAILABLE
#define	BYTESPERLONG		( BITSPERLONG / BITSPERBYTE )
#define BITSPERLONGLONG		ULONG_LONG_MAX_AVAILABLE
#define	BYTESPERLONGLONG	( BITSPERLONGLONG / BITSPERBYTE)
#define	BITSPERINT		UINT_MAX_AVAILABLE
#define BYTESPERINT		( BITSPERINT / BITSPERBYTE )

/* This is where it could get weird with odd byte and register sizes. 
*/

/* BYTESPERCELL etc., are now calculated in config/makecelltype.c,
** Still want to check at run-time. 
*/
typedef probe_ucell_t natural_t;
typedef probe_scell_t snatural_t;
#define	BITSPERCELL	PROBE_CELL_BIT
#define	BYTESPERCELL	PROBE_CELL_BYTE
#define	CELL_HIGH_BIT	((natural_t) PROBE_CELL_HIGH_BIT)
#define UCELL_MAX	((natural_t) PROBE_UCELL_MAX)
#define SCELL_MAX	((snatural_t) PROBE_SCELL_MAX)
#define SCELL_MIN	((snatural_t) PROBE_SCELL_MIN)

#define HIHALFCT ( BITSPERCELL / 2 )
#define LOHALFCT ( BITSPERCELL - HIHALFCT )

#define HALFHIMASK	((natural_t) ( UCELL_MAX << LOHALFCT ))
#define HALFLOMASK	((natural_t) ( UCELL_MAX >> HIHALFCT ))

#define HIHALFCELL( cell )	((natural_t) ( (cell) & HALFHIMASK ))
#define LOHALFCELL( cell )	((natural_t) ( (cell) & HALFLOMASK ))

#define HIHALFDOWN( cell )	((natural_t) ( (cell) >> LOHALFCT ))
/* Note: LOHALFUP will spill into the bit bucket on odd cell sizes. */
#define LOHALFUP( cell )	((natural_t) ( (cell) << LOHALFCT ))	

#define LOHALFCARRYMASK	((natural_t) ( 1 << LOHALFCT ))
#define LOHALFCARRYBIT( cell )	((natural_t) ( 1 & ( (cell) >> LOHALFCT ) ))

#if defined PROBE_DOUBLE_BIT && !defined SINGLE_C_CELL_DOUBLE
/* Note that bif-c uses the FORTH word order even on LSB-1st machines! */
	typedef udoublew_t dblnatural_t;
	typedef sdoublew_t sdblnatural_t;
#	define	BITSPERDOUBLE	PROBE_DOUBLE_BIT
#	define	BYTESPERDOUBLE	PROBE_DOUBLE_BYTE
#	define	DOUBLE_HIGH_BIT	((dblnatural_t) PROBE_DOUBLE_HIGH_BIT)
#	define	UDOUBLE_MAX	((dblnatural_t) PROBE_UDOUBLE_MAX)
#	define	SDOUBLE_MAX	((sdblnatural_t) PROBE_SDOUBLE_MAX)
#	define	SDOUBLE_MIN	((sdblnatural_t) PROBE_SDOUBLE_MIN)
#elif !defined PROBE_DOUBLE_BIT || defined SINGLE_C_CELL_DOUBLE
#	define MANUFACTURED_DOUBLE
/* Manufacture a stop-gap dblnatural_t */
	typedef union double_u
	{	natural_t upart[ 2 ];
		snatural_t spart[ 2 ];
	} dblnatural_t;
	typedef union sdouble_u
	{	snatural_t spart[ 2 ];
		natural_t upart[ 2 ];
	} sdblnatural_t;
#	define	BITSPERDOUBLE	( PROBE_CELL_BIT * 2 )
#	define	BYTESPERDOUBLE	( PROBE_CELL_BYTE * 2 )
/* These won't work in ordinary expressions, but this is the clue of how to do it: */
#	define	DOUBLE_HIGH_BIT	((dblnatural_t) { PROBE_CELL_HIGH_BIT, 0 } )
#	define	UDOUBLE_MAX	((dblnatural_t) { PROBE_UCELL_MAX, 0 })
#	define	SDOUBLE_MAX	((sdblnatural_t) { PROBE_SCELL_MAX, 0 })
#	define	SDOUBLE_MIN	((sdblnatural_t) { PROBE_SCELL_MIN, 0 })
#else /* dealing with doubles */
#error "What should we do with machines that defy numerical theory?"
#endif /* dealing with doubles */


/* This may not work if you are trying to define 
** a smaller natural integer than your CPU's natural integer.
** Otherwise, it should automatically be set to 
**	2 for 16 bit CPUs, eight bit bytes,
**	4 for 32 bit CPUs, eight bit bytes,
**	8 for 64 bit CPUs, eight bit bytes, 
** etc.
** If you have something odd like 36 bit integral math, you'll want to check the results.
** Maybe: 
**	#	undef	BYTESPERCELL
**	#	define	BYTESPERCELL 4 
** etc.
** Or, better yet, use the makefile 
** (Do we have one yet?) 
** to build and run a program to output the right types and defines.
** Or, for cross compiles, run the program by hand, or even build the types and macros by hand.
*/

/* Note that I haven't tested the source for any case but 32 bit cells, 
** and 8 bit bytes, yet.
** You'll need to work through the source code to be sure, for other sizes.
*/


/* Putting a little guard around DCONSTANT, I realize,
** I'm putting a lot of effort into catching odd cases of double width integers,
** and I'm missing in code the very case I'm trying so hard to get around here:
** the bit width of long long not an integer multiple of the width of cell_u
#if BITSPERDOUBLE <= 2 * BITSPERCELL
#	define	CELLSPERDOUBLE	2
#elif BITSPERDOUBLE <= 3 * BITSPERCELL
#	define	CELLSPERDOUBLE	3
#elif BITSPERDOUBLE <= 4 * BITSPERCELL
#	define	CELLSPERDOUBLE	4
#else
#	error "What is wrong with your forecast definitions of cell_u width?"
#endif
*/
#if BITSPERDOUBLE == 2 * BITSPERCELL
#	define	CELLSPERDOUBLE	2
#elif BITSPERDOUBLE == 3 * BITSPERCELL
#	define	CELLSPERDOUBLE	3
#elif BITSPERDOUBLE == 4 * BITSPERCELL
#	define	CELLSPERDOUBLE	4
#else
#	error "Odd sizes of integers requires special handling, structures and stuff."
#endif


#if BYTESPERCELL != 4
#	warning "Not necessarily ready for the cell size specified."
#endif


#define SYSTEM_TRAPS_NULLS	/* Need to make this conditional on architecture. Mac OS 10.3 traps. */



/* semantic sugar:
** (Should also be auto-generated, if possible.)
*/
typedef ubyte_t byte_t;
/* typedef signed char sbyte_t; get this from celltype.h, too. */
typedef byte_t * byte_p;
typedef sbyte_t * sbyte_p;

/* characters should be 32 bit, 
** but that's for a later iteration.
** For now, expect multi-byte, with minimal parsing.
** I suppose multibyte parsing will be the best for 16-bit CPUs.
// Don't forget to fix EMIT and related code if character_t is not unsigned char.
*/
typedef unsigned char character_t;
typedef signed char scharacter_t;
typedef character_t packed_cell_a[ BYTESPERCELL ];	/* Don't really want to use this, though. */
typedef character_t spacked_cell_a[ BYTESPERCELL ];

/* When it's time to implement bit arrays, I could add appropriate types here.
*/


/* Finally -- 
// Get this from celltype.h, too.
typedef void (* icode_f)(void);
*/


/* This struct also should be automatically generated where possible. 
*/
typedef union cell_u
{	natural_t integer;
	snatural_t sinteger;
	void * voidp;
	byte_p bytep;
	sbyte_p sbytep;
	union cell_u * cellp;
	struct taskrecord_s * task;
	struct boot_constants_s * bootConstantsp;
	icode_f	icode;
	icode_f * icodep;
/*	character_t character; // types smaller than natural_t should be handled via cast to avoid dependencies. */
	character_t * chString;
	scharacter_t * schString;
	dblnatural_t * doublep;
	sdblnatural_t * sdoublep;
	packed_cell_a packed_character;
	spacked_cell_a spacked_character; /* Primarily for the most significant character. */
	struct definition_header_s * definitionp;
	FILE * filep;	/* Not strictly necessary, with both byte_p and icode_f, but semantically "nice". */
} cell_u;

#define	k_CELLS_PER_DOUBLE	( ( sizeof (dblnatural_t) + sizeof (cell_u) - 1 ) / sizeof (cell_u) )


/* Since a cell can point to a definition header, the definitions are (partially) interdependent.
** Moved here from bif_m.h .
** Usages during initialization are different from usages at run time.
*/
typedef struct definition_header_s
{	cell_u	nameLink;	/* Bits above length are mode flags. Name is not far from header. C init with pointer. */
	cell_u	interpMode;	/* Making the mode bits explicit to help the C source-level initializations. */
	cell_u	allocLink;	/* Want to separate the allocation fields. */
	cell_u	allocMode;	/* Decoupling the allocation, making the C initializations easier. */
	cell_u	vocabLink;	/* Root of this definition's vocabulary. */
	cell_u	leftLink;	/* Binary tree, left child in order. */
	cell_u	rightLink;	/* Right child in order. */
	cell_u	codeLink;	/* Interpretation code for this definition. */
	cell_u	parameterLink[];	/* Parameters for the code for this definition. */
} definition_header_s;

/* During initializations, the allocation pointer should be used to form a linked list within the file.
** COLD would overwrite this per-file list after using it to build the tree.
** The list will be terminated by pointing back to the first entry.
** But that alters the semantics of COLD subtly, so I may want to add a third temperature of boot.
** This initialization of the symbol table at start-up is necessitated by the macro.
** Maybe I'll just not use the macro, after all, but leave it here for the comments.
*/

#define HEADER( name, mode, next, papa, code, param0 )	\
character_t s##name[] = "\0" #name;		/* Lead byte is length. */	\
definition_header_s h##name =	\
{	{ (natural_t) s##name },	/* May later overwrite with relative pointer? */	\
	{ mode },	/* No special modes. */	\
	{ (natural_t) &h##next },	/* Will link backwards within the allocation block, but who knows for C? */	\
	{ MFORE },	/* Do not allow it to be FORGET-forgotten. */	\
	{ (natural_t) &h##papa },	/* parent vocabulary, must set. */	\
	{ 0 },	/* left link, will be set during cold boot. */	\
	{ 0 },	/* right link, will be set during cold boot. */	\
	{ (natural_t) name },	/* The code this definition calls. */	\
	{ { param0 } }	/* Dummy first parameter to make the C macro easier. */	\
}	\

/* Something like this was useful when debugging the macro:
// HEADER( 1, 2, 3, 4, 5, 6 );
*/

/* If I build the symbol tables by hand, 
** I'll have to make three passes through 16+ files:
** One pass to paste in all the headers and link them into the allocation list,
** a second pass to link them to their parent vocabularies
** (Figuring out what I did to the vocabularies is necessary either way.),
** and a third pass to build the trees in each vocabulary.
** If I let the initialization code build it during the early-COLD boot-up stage, 
** I have to write and debug a C language function to string it together.
** Probably take about the same time, by the time I'm finished debugging?
** Building the table at boot will require adding a symbol list link to each file, 
** and then require dumping said list to an array for sorting, 
** and then I can finally process it, sort it, optimize it, build it up.
** And the routine has to work for every vocabulary.
** Not that bad, but it will take debugging.
** So will the hand-built tree, particulary, as I see I have mixed vocabularies leftover from BIF6809.
*/


/* To use a struct or not to use a struct, that was the question.
** #define US0	0
** #define UR0	( US0 + sizeof (cell_u) )
** Naw, let's not fight the C that much.
*/
#define UP_SPARE_COUNT 8
/*
00120 	ORG 0
*/
typedef struct taskrecord_s
{
/* 00130 US0	RMB 2	base of data stack (6809 U) */
	cell_u	dataStackBase;	/* upside down */
#define US0 ( offsetof( struct taskrecord_s, dataStackBase ) )

/* 00140 UR0	RMB 2	base of control stack (6809 S) */
	cell_u	returnStackBase;	/* upside down */
#define UR0 ( offsetof( struct taskrecord_s, returnStackBase ) )

/* 00150 UTIB	RMB 2	terminal buffer */
	cell_u	terminalInputBuffer;
#define UTIB ( offsetof( struct taskrecord_s, terminalInputBuffer ) )

/* 00160 	RMB 2	width is not used */
	cell_u	reserved_NameLengthMask;
#define UWIDTH ( offsetof( struct taskrecord_s, reserved_width ) )

/* 00170 UWARN	RMB 2	disk on line? */
	cell_u	diskOnLine;
#define UWARN ( offsetof( struct taskrecord_s, diskOnLine ) )

/* 00180 UFENCE	RMB 2	for FORGET */
	cell_u	forgetFence;
#define UFENCE ( offsetof( struct taskrecord_s, forgetFence ) )

/* 00190 UDP	RMB 2	first available byte in dictionary */
	cell_u	dictionaryAllocationPointer;
#define UDP ( offsetof( struct taskrecord_s, dictionaryAllocationPointer ) )

/* 00200 UROOT	RMB 2	current dictionary root pointer */
	cell_u	searchContextRoot;
#define UROOT ( offsetof( struct taskrecord_s, searchContextRoot ) )

/* 00210 UDROOT	RMB 2	defining dictionary root pointer */
	cell_u	definitionContextRoot;
#define UDROOT ( offsetof( struct taskrecord_s, definitionContextRoot ) )

/* 00220 UCURR	RMB 2	NFA of last definition */
	cell_u	lastDefined;
#define UCURR ( offsetof( struct taskrecord_s, lastDefined ) )

/* 00230 UPAD	RMB 2	text, numeric scratch buffers */
	cell_u	numericConversionScratchPad;
#define UPAD ( offsetof( struct taskrecord_s, numericConversionScratchPad ) )

/* 00240 UWP	RMB 2	WORD buffer pointer */
	cell_u	wordBufferPointer;
#define UWP ( offsetof( struct taskrecord_s, wordBufferPointer ) )

/* 00250 UCOLUM	RMB 2	columns per lineon terminal */
	cell_u	terminalColumns;	/* This is faked. */
#define UCOLUM ( offsetof( struct taskrecord_s, terminalColumns ) )

/* 00260 UFIRST	RMB 2	byte of buffers */
	cell_u	firstByteOfBuffers;
#define UFIRST ( offsetof( struct taskrecord_s, firstByteOfBuffers ) )

/* 00270 ULIMIT	RMB 2	of buffer ram */
	cell_u	limitOfBufferRAM;
#define ULIMIT ( offsetof( struct taskrecord_s, limitOfBufferRAM ) )

/* 00280 UBASE	RMB 2	of numeric conversion */
	cell_u	numericBase;
#define UBASE ( offsetof( struct taskrecord_s, numericBase ) )

/* 00290 UCSP	RMB 2	stack pointer check */
	cell_u	compilerStackMarker;
#define UCSP ( offsetof( struct taskrecord_s, compilerStackMarker ) )

/* 00300 UHLD	RMB 2	character mark in pad */
	cell_u	padMarker;
#define UHLD ( offsetof( struct taskrecord_s, padMarker ) )

/* 00310 UUSE	RMB 2	Least Recently Used buffer */
	cell_u	leastRecentBuffer;
#define UUSE ( offsetof( struct taskrecord_s, leastRecentBuffer ) )

/* 00320 UPREV	RMB 2	Most Recently Used buffer */
	cell_u	mostRecentBuffer;
#define UPREV ( offsetof( struct taskrecord_s, mostRecentBuffer ) )

/* 00330 UBS	RMB 2	BackSpace */
	cell_u	backSpaceConstant;
#define UBS ( offsetof( struct taskrecord_s, backSpaceConstant ) )

/* 00340 UIN	RMB 2	input buffer offset */
	cell_u	bufferInputOffset;
#define UIN ( offsetof( struct taskrecord_s, bufferInputOffset ) )

/* 00350 UOUT	RMB 2	output buffer offset (cursor) */
	cell_u	bufferOutputOffset;
#define UOUT ( offsetof( struct taskrecord_s, bufferOutputOffset ) )

/* 00360 UBLK	RMB 2	active disc block */
	cell_u	activeDiscBlock;
#define UBLK ( offsetof( struct taskrecord_s, activeDiscBlock ) )

/* 00370 UEBLK	RMB 2	active edit block */
	cell_u	activeEditBlock;
#define UEBLK ( offsetof( struct taskrecord_s, activeEditBlock ) )

/* 00380 USCR	RMB 2	active disc screen */
	cell_u	activeDiscScreen;
#define USCR ( offsetof( struct taskrecord_s, activeDiscScreen ) )

/* 00390 URNUM	RMB 2	editing offset (cursor) */
	cell_u	editingOffset;
#define URNUM ( offsetof( struct taskrecord_s, editingOffset ) )

/* 00400 UOFFS	RMB 2	to active drive */
	cell_u	activeDriveOffset;
#define UOFFS ( offsetof( struct taskrecord_s, activeDriveOffset ) )

/* 00410 USTATE	RMB 2	of compiler */
	cell_u	compilerState;
#define USTATE ( offsetof( struct taskrecord_s, compilerState ) )

/* 00420 UDPL	RMB 2	output Decimal Point Location */
	cell_u	decimalPoint;
#define UDPL ( offsetof( struct taskrecord_s, decimalPoint ) )

/* 00430 UFLD	RMB 2	output field width */
	cell_u	outputFieldWidth;
#define UFLD ( offsetof( struct taskrecord_s, outputFieldWidth ) )

/* 00440 UVMK	RMB 2	stack mark and function for VISIT */
	cell_u	visitedMark;
#define UVMK ( offsetof( struct taskrecord_s, visitedMark ) )

/* 00450 UFORE	RMB 2	FOREWARD reference block link */
	cell_u	forewardBlock;
#define UFORE ( offsetof( struct taskrecord_s, forewardBlock ) )

/* 00460 UDPR	RMB 2	Direct Page Emulator for Assembler */
	cell_u	directPageEmulator;
#define UDPR ( offsetof( struct taskrecord_s, directPageEmulator ) )

/* For changing the FENCE techniques, maybe, eventually. */
	cell_u	tailFence;
#define UTFENC ( offsetof( struct taskrecord_s, tailFence ) )

/* For flagging EXPECT echo. */
	cell_u	terminalEcho;
#define UXECHO ( offsetof( struct taskrecord_s, terminalEcho ) )

/* 00990 	RMB 16	8 spares  */
	cell_u	spare[ UP_SPARE_COUNT ];
#define USPARE ( offsetof( struct taskrecord_s, spare ) )

/* 01000 UEND	EQU *  */
} taskrecord_s;
#define UEND ( sizeof (taskrecord_s) )


/* Moved here from the tail of bif_a.c, for the obvious reasons.
// Don't need them all in every file, but they'll save us some trouble here,
// at least until I get to the refactoring. 
// At that point, I can move the necessary includes to the necessary non-headers.
// I hope.
*/
#include	"bifst_a.h"
#include	"bif_a.h"
#include	"bifb_a.h"
#include	"bif1_a.h"
#include	"bif1b_a.h"
#include	"bif2_a.h"
#include	"bif2b_a.h"
#include	"bif3_a.h"
#include	"bif3b_a.h"
#include	"bif4_a.h"
#include	"bif4b_a.h"
#include	"bif5_a.h"
#include	"bif5b_a.h"
#include	"bif6_a.h"
#include	"bif6b_a.h"
#include	"bif7_a.h"
#include	"bif7b_a.h"


#endif /* !defined BIFU_I_H */
