<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		AccessLogDate.class.php
 * @brief		月/日別アクセスクラス
 * @date		2007.02.07
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");

class AccessLogDate extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; アクセス数");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		// POSTデータが無い場合の初期値を設定
		if(!$_POST["view"])
			$_POST["view"] = "day";
		
		if(!$_POST["period"]["day"])
			$_POST["period"]["day"] = "30";
		
		if(!$_POST["period"]["mon"])
			$_POST["period"]["mon"] = "6";
		
		// ファイルからログ読み込み
		for($count = LOG_DIV; $count > 0; $count--)
		{
			if($fp = fopen(LOG_DIR."/log_".$_GET["group_code"]."_".$count.".dat","r"))
			{
				while(!feof($fp))
				{
					$log = fgets($fp);
					if(!is_bool($log))
					{
						// 抽出処理
						$temp = explode("\t",rtrim($log));
						if($_POST["view"] == "day")
						{
							$now = strtotime(date("Y/m/d",time()));
							$loop = $_POST["period"]["day"] + 1;
							for($day = 1; $day < $loop; $day++)
							{
								$period = strtotime("-".$day." day");
								if(($temp["0"] < $now) && ($temp["0"] > $period))
								{
									$access_array[strtotime(date("Y/m/d",$period))]++;
									$user_array[strtotime(date("Y/m/d",$period))][$temp["1"]]++;
									break;
								}
							}
						}
						else if($_POST["view"] == "mon")
						{
							$now = strtotime(date("Y/m",time())."/1");
							$loop = $_POST["period"]["mon"] + 1;
							for($month = 1; $month < $loop; $month++)
							{
								$period = strtotime("-".$month." month");
								if(($temp["0"] < $now) && ($temp["0"] > $period))
								{
									$access_array[strtotime(date("Y/m",$period)."/1")]++;
									$user_array[strtotime(date("Y/m",$period)."/1")][$temp["1"]]++;
									break;
								}
							}
						}
					}
				}
				fclose($fp);
			}
		}
		
		// ソート
		krsort($access_array);
		
		foreach($user_array as $date => $user)
			$user_array[$date] = count($user);
		
		$this->assign("view",$_POST["view"]);
		$this->assign("period",$_POST["period"]);
		$this->assign("access_array",$access_array);
		$this->assign("user_array",$user_array);
		
		$this->template = "AccessLogDate.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
