<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		EntryNonPublish.class.php
 * @brief		記事の掲載クラス
 * @date		2007.01.16
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");

class EntryNonPublish extends PageRender
{
	function makePage()
	{
		$dao = new EntryManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->npubEntry($_GET["entry_code"]);
		if(!$dao->CompleteTrans())
			$this->error("記事の非掲載に失敗しました。");
		
		$send_vars["mode"] = 1;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
