<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralBCCSSView.php
 * @brief		一般用CSSビュー(bitcube.css)クラス
 * @date		2007.05.01
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralBCCSSManager.class.php");

class GeneralBCCSSView extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralBCCSSManager();
		$css = $dao->getBCCSSInfo($_GET["group_code"]);
		if(!$css)
		{
			$this->error("Not Found");
		}
		$this->assignBitcubeTags($css["group_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".$css["bitcube_css_tmpl"];
	}
	
	function render()
	{
		$this->makeView();
		$this->renderView();
	}
}
