<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralBaseCSSView.php
 * @brief		一般用CSSビュー(base.css)クラス
 * @date		2007.05.01
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralBaseCSSManager.class.php");

class GeneralBaseCSSView extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralBaseCSSManager();
		$css = $dao->getBaseCSSInfo($_GET["group_code"]);
		if(!$css)
		{
			$this->error("Not Found");
		}
		$this->assignBitcubeTags($css["group_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".$css["base_css_tmpl"];
	}
	
	function render()
	{
		$this->makeView();
		$this->renderView();
	}
}
