<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralModuleView.class.php
 * @brief		一般用モジュールビュークラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralModuleManager.class.php");

class GeneralModuleView extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralModuleManager();
		$module = $dao->getModuleInfo($_GET["group_code"],$_GET["module_code"]);
		if(!$module)
			$this->error("Not Found");
		
		$this->assignBitcubeTags($module["group_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".$module["module_body"];
	}
	
	function render()
	{
		$this->makeView();
		$this->renderView();
	}
}
