<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GroupDelete.class.php
 * @brief		更新セットの削除クラス
 * @date		2007.01.17
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/file/MakeHtaccess.class.php");

class GroupDelete extends PageRender
{
	function makePage()
	{
		$dao = new GroupManager();
		$current_group = $dao->getGroupInfo($_GET["group_code"]);
		
		$dao->StartTrans();
		$dao->Lock();
		$dao->delGroup($_GET["group_code"]);
		if(!$dao->CompleteTrans())
			$this->error("更新セットの削除に失敗しました。");
		
		$htaccess = new MakeHtaccess();
		if(!$htaccess->execute())
			$this->error("更新セットの削除に失敗しました。");
		
		if($dao->GetCount($dao->entry,"group_code = ".$_GET["group_code"]) == 0)
			system("rm -r \"".DATA_DIR."/".$_GET["group_code"]."\" ");
		
		$send_vars["mode"] = 3;
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
