<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GroupEdit.class.php
 * @brief		更新セットの編集クラス
 * @date		2007.01.23
 */

require_once(CLASS_DIR."/form/GroupInputForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/file/MakeHtaccess.class.php");

class GroupEdit extends GroupInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; ステータス編集");
		
		$this->dao = new GroupManager();
		$group_array = $this->dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $this->dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->assign("name",$this->current_group["group_name"]);
		$this->assign("dir_name",$this->current_group["group_dir_name"]);
		$this->assign("upload_dir_name",$this->current_group["group_upload_dir_name"]);
		$this->assign("default_publish",$this->current_group["group_default_publish"]);
		$this->assign("summary_strings_num",$this->current_group["group_summary_strings_num"]);
		$this->template = "GroupEditInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setGroupName($_POST["name"]);
		$this->setDirName($_POST["dir_name"]);
		$this->setUploadDirName($_POST["upload_dir_name"]);
		$this->setDefaultPublish($_POST["default_publish"]);
		$this->setSummaryStringsNum($_POST["summary_strings_num"]);
		$form_error_array = $this->check();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "GroupEditInput.tpl";
		}
		else
		{
			$this->assign("state",3);
			$this->assign("message_array","下記の内容で登録します。よろしければ「登録」ボタンを押してください。<br />修正をする場合は「編集」ボタンよりお戻りください。");
			$this->template = "GroupEditConfirm.tpl";
		}
		
		$this->assign("name",$_POST["name"]);
		$this->assign("dir_name",$_POST["dir_name"]);
		$this->assign("upload_dir_name",$_POST["upload_dir_name"]);
		$this->assign("default_publish",$_POST["default_publish"]);
		$this->assign("summary_strings_num",$_POST["summary_strings_num"]);
	}
	
	// 完了
	function complete()
	{
		$record = array();
		$record["group_name"] = $_POST["name"];
		$record["group_dir_name"] = $_POST["dir_name"];
		$record["group_upload_dir_name"] = $_POST["upload_dir_name"];
		$record["group_default_publish"] = $_POST["default_publish"];
		$record["group_summary_strings_num"] = $_POST["summary_strings_num"];
		$code = $_GET["group_code"];
		
		$this->dao->StartTrans();
		$this->dao->Lock();
		$this->dao->updGroup($record,$code);
		if(!$this->dao->CompleteTrans())
			$this->error("更新セットの修正に失敗しました。");
		
		$htaccess = new MakeHtaccess();
		if(!$htaccess->execute())
			$this->error("更新セットの修正に失敗しました。");
		
		$_POST["state"] = 1;
		$this->assign("message_array","変更内容を保存しました。");
		
		$this->makeForm();
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderForm();
	}
}
