<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		weblogUpdates.class.php
 * @brief		更新ping送信クラス
 * @date		2007.08.30
 */

require_once(LIBRARY_DIR."/PEAR/XML/RPC.php");

$GLOBALS["XML_RPC_defencoding"] = "UTF-8";

class weblogUpdates
{
	function SendUpdatePing($server="",$name="",$url="")
	{
		// クライアント作成
		$server_array = parse_url($server);
		$xmlrpc_host = $server_array["host"];
		$xmlrpc_path = $server_array["path"];
		$c = new XML_RPC_client($xmlrpc_path,$xmlrpc_host,80);
		
		// メッセージ作成
		$params = array(
			new XML_RPC_Value($name,"string"),
			new XML_RPC_Value($url,"string")
		);
		$message = new XML_RPC_Message("weblogUpdates.ping",$params);
		
		// 送信
		return $c->send($message);
	}
	
	function SendUpdateExtendedPing($server="",$name="",$url="",$c_url="",$rss="",$category="")
	{
		// クライアント作成
		$server_array = parse_url($server);
		$xmlrpc_host = $server_array["host"];
		$xmlrpc_path = $server_array["path"];
		$c = new XML_RPC_client($xmlrpc_path,$xmlrpc_host,80);
		
		// メッセージ作成
		$params = array(
			new XML_RPC_Value($name,"string"),
			new XML_RPC_Value($url,"string"),
			new XML_RPC_Value($c_url,"string"),
			new XML_RPC_Value($rss,"string"),
			new XML_RPC_Value($category,"string")
		);
		$message = new XML_RPC_Message("weblogUpdates.extendedPing",$params);
		
		// 送信
		return $c->send($message);
	}
}
