<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		functions.php
 * @brief		共通関数郡
 * @date		2006.12.16
 */

// クォートされた文字列のクォート部分を取り除く
function stripslashes_deep($value)
{
	$value = is_array($value) ?
		array_map("stripslashes_deep",$value):
		stripslashes($value);
	return $value;
}

// Unicodeベンダ依存文字修正
function unicode_fix(&$value,$key)
{
	$pattern = array(
		"/\xEF\xBF\xA3/",
		"/\xE2\x80\x95/",
		"/\xE3\x80\x9C/",
		"/\xE2\x80\x96/",
		"/\xE2\x80\xA6/",
		"/\xE2\x88\x92/",
		"/\x00\xC2\xA2/",
		"/\x00\xC2\xA3/",
		"/\x00\xC2\xAC/");
	
	$replacement = array(
		"",
		"－",
		"～",
		"||",
		"...",
		"－",
		"c",
		"L",
		"－");
	$value = preg_replace($pattern,$replacement,$value);
}

// 文字列の先頭および末尾にある空白を取り除く
function trim_deep($value)
{
	$value = is_array($value) ?
		array_map("trim_deep",$value):
		trim($value);
	return $value;
}

// HTTPリダイレクト
function redirect($url,$send_vars)
{
	if($url)
	{
		if($send_vars)
		{
			$url .= "?";
			foreach($send_vars as $name => $value)
				$url .= $name."=".$value."&";
		}
		header("Location: ".preg_replace("/(&)$/","",$url));
		exit;
	}
	else
	{
		return false;
	}
}

// 半角文字チェック
function is_hankaku($string)
{
	$strlen = strlen($string);
	$strcnt = mb_strlen($string);
	
	if($strlen == $strcnt)
		return true;
	else
		return false;
}

// 数値チェック
function is_num($string)
{
	if(preg_match("/^[0-9]+$/",$string))
		return true;
	else
		return false;
}

// ファイル名チェック
function is_filename($string)
{
	if(preg_match("/^[a-zA-Z0-9\_\.\-]+$/",$string))
		return true;
	else
		return false;
}

// ディレクトリ名チェック
function is_dirname($string)
{
	if(preg_match("/^[a-zA-Z0-9\_\-]+$/",$string))
		return true;
	else
		return false;
}

// アカウントチェック
function is_account($string)
{
	if(preg_match("/^[a-zA-Z0-9]+$/",$string))
		return true;
	else
		return false;
}

// アルファベットチェック
function is_alphabet($string)
{
	if(preg_match("/^[a-zA-Z]+$/",$string))
		return true;
	else
		return false;
}

// ファイルリスト取得
function get_filelist($path)
{
	$filelist = array();
	if($dir = opendir($path))
	{
		while(($file = readdir($dir)) !== false)
		{
			if(is_file($path.$file))
			{
				$filelist[$path.$file]["name"] = $file;
				$filelist[$path.$file]["time"] = filemtime($path.$file);
				$filelist[$path.$file]["size"] = filesize($path.$file);
			}
		}
		closedir($dir);
	}
	else
	{
		return false;
	}
	return $filelist;
}

// 多次元配列ソート
function sort0asc($a,$b)
{
	return strcmp($a[0],$b[0]);
}

function sort0desc($a,$b)
{
	return strcmp($b[0],$a[0]);
}

// マルチバイト文字を返す
function mb_chr($num)
{
	return ($num < 256) ?
		chr($num):
		mb_chr($num / 256).chr($num % 256);
}

// マルチバイト文字のASCII値を返す
function mb_ord($char)
{
	return (strlen($char) < 2) ?
		ord($char):
		256 * mb_ord(substr($char, 0, -1)) + ord(substr($char, -1));
}
