<?php
/*
 * Copyright(C). phonogram,Inc. All Rights Reserved.
 */

/*
 * @file		atom_reader.php
 * @brief		atom reader
 * @author		Yuki Yoshioka
 * @date		2007.05.16
 */

class atom_reader
{
	function atom_reader()
	{
		$this->init();
	}
	
	function init()
	{
		$this->rss = "";
		$this->encoding = mb_internal_encoding();
		$this->count = 0;
		$this->tmp_value = "";
		$this->rss_array = array();
	}
	
	function setRSS($rss)
	{
		$this->rss = $rss;
	}
	
	function setEncoding($encoding)
	{
		$this->encoding = $encoding;
	}
	
	function getRSS()
	{
		$xml_parser = xml_parser_create();
		xml_parser_set_option($xml_parser,XML_OPTION_CASE_FOLDING,false);
		xml_set_element_handler($xml_parser,array(&$this,"startElement"),array(&$this,"endElement"));
		xml_set_character_data_handler($xml_parser,array(&$this,"characterData"));
		
		$data = file_get_contents($this->rss);
		
		if(!xml_parse($xml_parser,$data))
		{
			return false;
		}
		
		xml_parser_free($xml_parser);
		
		array_shift($this->rss_array);
		return $this->rss_array;
	}
	
	function startElement($parser,$name,$attribs)
	{
		if($name == "entry")
		{
			$this->count++;
		}
	}
	
	function endElement($parser,$name)
	{
		if($this->tmp_value != "")
		{
			$this->rss_array[$this->count][$name] = $this->tmp_value;
		}
		
		$this->tmp_value = "";
	}
	
	function characterData($parser,$text)
	{
		$old_encoding = mb_detect_encoding($text);
		$this->tmp_value = trim(mb_convert_encoding($text,$this->encoding,$old_encoding));
	}
	
	function getResult()
	{
		return $this->getRSS();
	}
}
