<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		PageRender.class.php
 * @brief		ページレンダリングクラス
 * @date		2006.12.13
 */

class PageRender
{
	var $smarty;
	var $template;
	
	function PageRender()
	{
		global $smarty;
		$this->smarty = &$smarty;
	}
	
	function assign($name,$value)
	{
		$this->smarty->assign($name,$value);
	}
	
	function display($template)
	{
		$this->smarty->display($template);
	}
	
	function default_modifiers($array)
	{
		$this->smarty->default_modifiers = $array;
	}
	
	function fetch($template)
	{
		return $this->smarty->fetch($template);
	}
	
	function register_resource($name)
	{
		$this->smarty->register_resource($name,array("get_smarty_template",
			"get_smarty_timestamp",
			"get_smarty_secure",
			"get_smarty_trusted"));
	}
	
	function renderPage()
	{
		$this->display("common/header.tpl");
		$this->display($this->template);
		$this->display("common/footer.tpl");
	}
	
	function renderError($error)
	{
		$this->assign("error_msg",$error);
		$this->display("common/header.tpl");
		$this->display("common/critical_error.tpl");
		$this->display("common/footer.tpl");
	}
	
	function error($msg)
	{
		$this->renderError($msg);
		exit;
	}
}
