<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		CategoryDelete.class.php
 * @brief		カテゴリの削除クラス
 * @date		2006.12.20
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/CategoryManager.class.php");

class CategoryDelete extends PageRender
{
	function makePage()
	{
		$dao = new CategoryManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->delCategory($_GET["category_code"]);
		if(!$dao->CompleteTrans())
			$this->error("カテゴリの削除に失敗しました。");
		
		$send_vars["mode"] = 15;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
