<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		EntryOrder.class.php
 * @brief		記事のオーダー入れかえクラス
 * @date		2007.01.29
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");

class EntryOrder extends PageRender
{
	function makePage()
	{
		$dao = new EntryManager();
		if($_SESSION["search"]["1"][$_GET["group_code"]]["category_code"] == "0")
			$condition .= " and $dao->entry.category_code = 0 ";
		else if(strlen($_SESSION["search"]["1"][$_GET["group_code"]]["category_code"]) > 0)
			$condition .= " and $dao->entry.category_code = ".$_SESSION["search"]["1"][$_GET["group_code"]]["category_code"]." ";
		
		if($_SESSION["search"]["1"][$_GET["group_code"]]["search_word"])
			foreach(preg_split("/[\s]+/",trim($_SESSION["search"]["1"][$_GET["group_code"]]["search_word"])) as $search_word)
				$condition .= " and $dao->entry.entry_title like ".$dao->qstr("%".$search_word."%")." ";
		
		$result = $dao->getNextPrevEntry($_GET["entry_code"],"$dao->entry.entry_order desc","$dao->entry.group_code = ".$_GET["group_code"].$condition);
		
		if($_GET["move"] == "up")
			$target_code = $result["top"];
		else if($_GET["move"] == "down")
			$target_code = $result["bottom"];
		
		$dao->StartTrans();
		$dao->Lock();
		if($target_code)
			$dao->cngEntryOrder($_GET["entry_code"],$target_code);
		if(!$dao->CompleteTrans())
			$this->error("記事の入れ替えに失敗しました。");
		
		$send_vars["mode"] = 1;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
