<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralATOMView.class.php
 * @brief		一般用ATOMビュークラス
 * @date		2007.01.25
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralATOMManager.class.php");

class GeneralATOMView extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralATOMManager();
		$atom = $dao->getATOMInfo($_GET["group_code"]);
		if(!$atom)
			$this->error("Not Found");
		
		$this->assignBitcubeTags($atom["group_code"]);
		$this->assignRSSTags($atom["group_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".$atom["atom_tmpl"];
	}
	
	function render()
	{
		$this->makeView();
		$this->renderRSSView();
	}
}
