<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralTopView.class.php
 * @brief		一般用トップページビュークラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralTopManager.class.php");

class GeneralTopView extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralTopManager();
		$top = $dao->getTopInfo($_GET["group_code"]);
		if(!$top)
			$this->error("Not Found");
		
		$this->assignBitcubeTags($top["group_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".$top["top_page_tmpl"];
	}
	
	function render()
	{
		$this->makeView();
		$this->renderView();
	}
}
