<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GroupEntry.class.php
 * @brief		更新セットの新規登録クラス
 * @date		2006.12.14
 */

require_once('./config/group.default.php');
require_once(CLASS_DIR.'/form/GroupInputForm.class.php');
require_once(CLASS_DIR.'/adodb/GroupManager.class.php');
require_once(CLASS_DIR.'/adodb/TemplateManager.class.php');
require_once(CLASS_DIR.'/file/MakeHtaccess.class.php');

class GroupEntry extends GroupInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; 更新セット新規登録");
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->assign("upload_dir_name",UPLOAD_DIR_NAME);
		$this->assign("default_publish",DEFAULT_PUBLISH);
		$this->assign("summary_strings_num",SUMMARY_STRINGS_NUM);
		$this->assignGroupList();
		$this->template = "GroupEntryInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setGroupName($_POST["name"]);
		$this->setDirName($_POST["dir_name"]);
		$this->setUploadDirName($_POST["upload_dir_name"]);
		$this->setDefaultPublish($_POST["default_publish"]);
		$this->setSummaryStringsNum($_POST["summary_strings_num"]);
		$form_error_array = $this->check();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "GroupEntryInput.tpl";
		}
		else
		{
			$this->assign("state",3);
			$this->assign("message_array","下記の内容で登録します。よろしければ「登録」ボタンを押してください。<br />修正をする場合は「編集」ボタンよりお戻りください。");
			$this->template = "GroupEntryConfirm.tpl";
		}
		
		$this->assignGroupList();
		$this->assign("name",$_POST["name"]);
		$this->assign("dir_name",$_POST["dir_name"]);
		$this->assign("upload_dir_name",$_POST["upload_dir_name"]);
		$this->assign("default_publish",$_POST["default_publish"]);
		$this->assign("summary_strings_num",$_POST["summary_strings_num"]);
	}
	
	// 完了
	function complete()
	{
		$record = array();
		$record["group_name"] = $_POST["name"];
		$record["group_dir_name"] = $_POST["dir_name"];
		$record["group_upload_dir_name"] = $_POST["upload_dir_name"];
		$record["group_default_publish"] = $_POST["default_publish"];
		$record["group_summary_strings_num"] = $_POST["summary_strings_num"];
		
		$dao = new GroupManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->insGroup($record);
		if(!$dao->CompleteTrans())
			$this->error("更新セットの新規登録に失敗しました。");
		
		$this->assignGroupList();
		$new_group_code = $dao->getLastGroupCode();
		$this->assign("new_group",$new_group_code);
		
		$record = array();
		$record["group_code"] = $new_group_code;
		$record["top_page_tmpl"] = $this->fetch("../top_page.tpl");
		$record["category_page_tmpl"] = $this->fetch("../category_page.tpl");
		$record["news_detail_tmpl"] = $this->fetch("../news_detail.tpl");
		$record["rss1_tmpl"] = $this->fetch("../rss1.tpl");
		$record["rss2_tmpl"] = $this->fetch("../rss2.tpl");
		$record["atom_tmpl"] = $this->fetch("../atom.tpl");
		$record["base_css_tmpl"] = $this->fetch("../base.css.tpl");
		$record["bitcube_css_tmpl"] = $this->fetch("../bitcube.css.tpl");
		$record["bitcube_ie5win_tmpl"] = $this->fetch("../bitcube_ie5win.css.tpl");

		$dao_template = new TemplateManager();
		$dao_template->StartTrans();
		$dao_template->Lock();
		$dao_template->insTemplate($record);
		if(!$dao_template->CompleteTrans())
			$this->error("更新セットの新規登録に失敗しました。");
		
		$htaccess = new MakeHtaccess();
		if(!$htaccess->execute())
			$this->error("更新セットの新規登録に失敗しました。");
		
		if(!is_dir(DATA_DIR."/".$new_group_code))
		{
			mkdir(DATA_DIR."/".$new_group_code);
		}
		
		if(is_dir(DATA_DIR."/".$new_group_code))
		{
			//初期テンプレート用の画像を転送します。
			copy(TEMPLATE_DIR.'/'.'../img/favicon.ico',DATA_DIR.'/'.$new_group_code.'/'.'favicon.ico');
			copy(TEMPLATE_DIR.'/'.'../img/yain.gif',DATA_DIR.'/'.$new_group_code.'/'.'yain.gif');
		}
		
		$send_vars["mode"] = 1;
		$send_vars["group_code"] = $new_group_code;
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function assignGroupList()
	{
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderForm();
	}
}
