<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		NewEntryFileUpload.class.php
 * @brief		新規登録記事画像アップロードクラス
 * @date		2007.02.02
 */

require_once(CLASS_DIR."/form/FileUploadInputForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");

class NewEntryFileUpload extends FileUploadInputForm
{
	function makeForm()
	{
		$this->dao = new GroupManager();
		$this->current_group = $this->dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		if($_GET["entry_code"])
		{
			$this->assign("entry_code",$_GET["entry_code"]);
			mkdir(DATA_DIR."/".$this->current_group["group_code"]."/".$_GET["entry_code"]);
		}
		else
		{
			$this->error("テンポラリフォルダの作成に失敗しました。");
		}
		
		if($_GET["delete_file"])
		{
			if(unlink(DATA_DIR."/".$this->current_group["group_code"]."/".$_GET["entry_code"]."/".$_GET["delete_file"]))
			{
				$send_vars["mode"] = 11;
				$send_vars["group_code"] = $this->current_group["group_code"];
				$send_vars["entry_code"] = $_GET["entry_code"];
				redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
			}
			else
			{
				$this->error("ファイルの削除に失敗しました。");
			}
		}
		
		$this->file_array = get_filelist(DATA_DIR."/".$this->current_group["group_code"]."/".$_GET["entry_code"]."/");
		if($this->file_array === false)
			$this->error("ファイル一覧の取得に失敗しました。");
		$this->assign("file_array",$this->file_array);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->template = "NewEntryFileUpload.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setFileName($_FILES["file"]["name"]);
		$this->setFileSize($_FILES["file"]["size"]);
		$form_error_array = $this->check();
		
		if(count($form_error_array) > 0)
		{
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "NewEntryFileUpload.tpl";
		}
		else
		{
			if(!move_uploaded_file($_FILES["file"]["tmp_name"],DATA_DIR."/".$this->current_group["group_code"]."/".$_GET["entry_code"]."/".$_FILES["file"]["name"]))
				$this->error("ファイルのアップロードに失敗しました。");
			
			$send_vars["mode"] = 11;
			$send_vars["group_code"] = $this->current_group["group_code"];
			$send_vars["entry_code"] = $_GET["entry_code"];
			redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
		}
	}
	
	function render()
	{
		$this->makeForm();
		$this->display($this->template);
	}
}
