<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TemplateList.class.php
 * @brief		テンプレート一覧クラス
 * @date		2006.12.19
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/TemplateModuleManager.class.php");

class TemplateList extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; テンプレート一覧");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$current_group);
		
		$template_module_dao = new TemplateModuleManager();
		$template_module = $template_module_dao->getTemplateModuleList("$template_module_dao->template_module.module_code desc","$template_module_dao->template_module.group_code = ".$_GET["group_code"]);
		$this->assign("template_module_array",$template_module);
		
		$this->template = "TemplateList.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
