<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TemplateRSS2Edit.class.php
 * @brief		RSS2.0テンプレートの編集クラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/form/TemplateInputForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/TemplateManager.class.php");

class TemplateRSS2Edit extends TemplateInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; <a href=\"./index.php?mode=7&group_code=".$_GET["group_code"]."\">RSS設定編集</a> &gt; テンプレート編集");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$template_dao = new TemplateManager();
		$template = $template_dao->getTemplateInfo($_GET["group_code"]);
		
		$this->assign("state",2);
		$this->assign("body",$template["rss2_tmpl"]);
		$this->template = "TemplateRSS2EditInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$form_error_array = $this->check();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "TemplateRSS2EditInput.tpl";
		}
		else
		{
			$this->assign("state",3);
			$this->assign("message_array","下記の内容で登録します。よろしければ「登録」ボタンを押してください。<br />修正をする場合は「編集」ボタンよりお戻りください。");
			$this->template = "TemplateRSS2EditConfirm.tpl";
		}
		
		$this->assign("body",$_POST["body"]);
	}
	
	// 完了
	function complete()
	{
		$record = array();
		$record["rss2_tmpl"] = $_POST["body"];
		$code = $_GET["group_code"];
		
		$dao = new TemplateManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->updTemplate($record,$code);
		if(!$dao->CompleteTrans())
			$this->error("テンプレートの修正に失敗しました。");
		
		$send_vars["mode"] = 7;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderForm();
	}
}
