<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TrashList.class.php
 * @brief		ごみ箱クラス
 * @date		2007.01.17
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");

class TrashList extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; ごみ箱");
		
		if(count($_POST) > 0)
		{
			$_SESSION["page"]["27"][$_GET["group_code"]] = 1;
			$_SESSION["search"]["27"][$_GET["group_code"]] = array();
			
			$_SESSION["per_page"]["27"][$_GET["group_code"]] = $_POST["per_page"];
			$_SESSION["search"]["27"][$_GET["group_code"]]["search_word"] = preg_replace("/\s\s+/"," ",mb_convert_kana(trim($_POST["search_word"]),"s"));
		}
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$entry_dao = new EntryManager();
		
		$condition = "$entry_dao->entry.is_delete = 1 ";
		if($_SESSION["search"]["27"][$_GET["group_code"]]["search_word"])
			foreach(preg_split("/[\s]+/",trim($_SESSION["search"]["27"][$_GET["group_code"]]["search_word"])) as $search_word)
				$condition .= " and $entry_dao->entry.entry_title like ".$entry_dao->qstr("%".$search_word."%")." ";
		
		$group_entry_array = $entry_dao->getEntryTrashList("$entry_dao->entry.entry_order desc",$condition,$_SESSION["per_page"]["27"][$_GET["group_code"]],$_SESSION["page"]["27"][$_GET["group_code"]]);
		$this->assign("group_entry_array",$group_entry_array->GetArray());
		$this->assign("current_page",$group_entry_array->AbsolutePage());
		$this->assign("first_page",$group_entry_array->AtFirstPage());
		$this->assign("last_page",$group_entry_array->AtLastPage());
		
		$entry_count = $entry_dao->getEntryTrashCount($condition);
		$this->assign("page_count",ceil($entry_count/$_SESSION["per_page"]["27"][$_GET["group_code"]]));
		
		$this->assign("per_page",$_SESSION["per_page"]["27"][$_GET["group_code"]]);
		$this->assign("search_word",$_SESSION["search"]["27"][$_GET["group_code"]]["search_word"]);
		
		$this->template = "TrashList.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
