<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TrashReturn.class.php
 * @brief		ごみ箱から元に戻すクラス
 * @date		2007.01.17
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");
require_once(CLASS_DIR."/file/MakeHtaccess.class.php");

class TrashReturn extends PageRender
{
	function makePage()
	{
		$group_dao = new GroupManager();
		$current_group = $group_dao->getGroupInfo($_GET["group_code"],true);
		
		$entry_dao = new EntryManager();
		$entry_dao->StartTrans();
		$entry_dao->Lock();
		$entry_dao->rtnEntry($_GET["entry_code"]);
		if(!$entry_dao->CompleteTrans())
			$this->error("記事の復旧に失敗しました。");
		
		$htaccess = new MakeHtaccess();
		if(!$htaccess->execute())
			$this->error("記事の復旧に失敗しました。");
		
		// データディレクトリ復旧
		if(!is_dir(DATA_DIR."/".$_GET["group_code"]))
			mkdir(DATA_DIR."/".$_GET["group_code"]);
		if(!is_dir(DATA_DIR."/".$_GET["group_code"]."/".$_GET["entry_code"]))
			mkdir(DATA_DIR."/".$_GET["group_code"]."/".$_GET["entry_code"]);
		
		$send_vars["mode"] = 27;
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
