<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GroupManager.class.php
 * @brief		groupテーブルの処理を行うクラス
 * @date		2007.01.19
 */

require_once("./config/group.default.php");
require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class GroupManager extends BitcubeDB
{
	function GroupManager()
	{
		$this->BitcubeDB();
	}
	
	// 更新セット情報取得
	function getGroupInfo($code,$release=false)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->group.group_code ";
		$sql .= " ,$this->group.group_regist_date ";
		$sql .= " ,$this->group.group_modification_date ";
		$sql .= " ,$this->group.group_name ";
		$sql .= " ,$this->group.group_meta_description ";
		$sql .= " ,$this->group.group_meta_keyword ";
		$sql .= " ,$this->group.group_dir_name ";
		$sql .= " ,$this->group.group_upload_dir_name ";
		$sql .= " ,$this->group.group_default_publish ";
		$sql .= " ,$this->group.group_summary_strings_num ";
		$sql .= " ,$this->group.group_rss_output_num ";
		$sql .= " ,$this->group.group_rss1_output ";
		$sql .= " ,$this->group.group_rss1_file_name ";
		$sql .= " ,$this->group.group_rss2_output ";
		$sql .= " ,$this->group.group_rss2_file_name ";
		$sql .= " ,$this->group.group_atom_output ";
		$sql .= " ,$this->group.group_atom_file_name ";
		$sql .= " ,$this->group.group_rss_copyright ";
		$sql .= " ,$this->group.group_rss_creator ";
		$sql .= " ,$this->group.group_ping_other_sites ";
		$sql .= " ,(select sum($this->entry.entry_page_view) from $this->entry where $this->entry.group_code = $this->group.group_code and $this->entry.is_delete = 0) as group_page_view ";
		$sql .= " from ";
		$sql .= " $this->group ";
		if(!$release)
			$sql .= " where $this->group.is_delete = 0 and $this->group.group_code = $code ";
		else
			$sql .= " where $this->group.group_code = $code ";
		
		return $this->GetRow($sql);
	}
	
	// 更新セット情報一覧取得
	function getGroupList($orderby="",$condition="",$offset=-1,$limit=-1)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->group.group_code ";
		$sql .= " ,$this->group.group_name ";
		$sql .= " ,$this->group.group_modification_date ";
		$sql .= " ,$this->group.group_dir_name ";
		$sql .= " from ";
		$sql .= " $this->group ";
		
		// 条件文
		$condition = ($condition) ?
			" where $this->group.is_delete = 0 and $condition ":
			" where $this->group.is_delete = 0 ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		else
			$orderby = " order by $this->group.group_code asc ";
		
		$sql .= $condition.$orderby;
		
		$rs = $this->SelectLimit($sql,$limit,$offset);
		
		return $rs->GetArray();
	}
	
	// 更新セットコード一覧取得
	function getGroupCodeList($orderby="",$condition="",$offset=-1,$limit=-1)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->group.group_code ";
		$sql .= " from ";
		$sql .= " $this->group ";
		
		// 条件文
		if($condition)
			$condition = " where $condition ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		$rs = $this->SelectLimit($sql,$limit,$offset);
		
		return $rs->GetArray();
	}
	
	// 更新セット情報追加
	function insGroup($record)
	{
		$record["group_code"] = $this->getNextGroupCode();
		$record["group_regist_date"] = str_replace("'","",$this->DBTimeStamp());
		$record["group_modification_date"] = str_replace("'","",$this->DBTimeStamp());
		$record["group_meta_description"] = "";
		$record["group_meta_keyword"] = "";
		$record["group_rss_output_num"] = RSS_OUTPUT_NUM;
		$record["group_rss1_output"] = RSS1_OUTPUT;
		$record["group_rss1_file_name"] = RSS1_FILE_NAME;
		$record["group_rss2_output"] = RSS2_OUTPUT;
		$record["group_rss2_file_name"] = RSS2_FILE_NAME;
		$record["group_atom_output"] = ATOM_OUTPUT;
		$record["group_atom_file_name"] = ATOM_FILE_NAME;
		$record["group_rss_copyright"] = "";
		$record["group_rss_creator"] = "";
		$record["group_ping_other_sites"] = PING_OTHER_SITES;
		$record["is_delete"] = 0;
		
		return $this->ExecuteInsert($this->group,$record);
	}
	
	// 更新セット情報編集
	function updGroup($record,$code)
	{
		$record["group_modification_date"] = str_replace("'","",$this->DBTimeStamp());
		return $this->ExecuteUpdate($this->group,$record,"group_code = ".$code);
	}
	
	// 更新セット情報削除
	function delGroup($code)
	{
		if($this->GetCount($this->entry,"group_code = $code") > 0)
		{
			$record["is_delete"] = 1;
			
			if(!$this->ExecuteUpdate($this->entry,$record,"group_code = $code"))
				return false;
			if(!$this->ExecuteUpdate($this->category,$record,"group_code = $code"))
				return false;
			if(!$this->ExecuteUpdate($this->template,$record,"group_code = $code"))
				return false;
			if(!$this->ExecuteUpdate($this->template_module,$record,"group_code = $code"))
				return false;
			return $this->ExecuteUpdate($this->group,$record,"group_code = $code");
		}
		else
		{
			if(!$this->ExecuteDelete($this->category,"group_code = $code"))
				return false;
			if(!$this->ExecuteDelete($this->template,"group_code = $code"))
				return false;
			if(!$this->ExecuteDelete($this->template_module,"group_code = $code"))
				return false;
			return $this->ExecuteDelete($this->group,"group_code = $code");
		}
	}
	
	// 最新コードを取得
	function getLastGroupCode()
	{
		return $this->GetMax($this->group,"group_code");
	}
	
	// 新規追加されるコードを取得
	function getNextGroupCode()
	{
		return $this->getLastGroupCode() + 1;
	}
	
	// ディレクトリ重複チェック
	function findGroupDirName($group_dir_name,$exception)
	{
		$condition = "group_dir_name = ".$this->qstr($group_dir_name)." and group_dir_name <> ".$this->qstr($exception);
		if($this->GetCount($this->group,$condition) > 0)
			return true;
		else
			return false;
	}
	
	// テーブルをロック
	function Lock()
	{
		$this->doLock($this->group);
	}
}
