<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TemplateManager.class.php
 * @brief		templateテーブルの処理を行うクラス
 * @date		2007.01.22
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class TemplateManager extends BitcubeDB
{
	function TemplateManager()
	{
		$this->BitcubeDB();
	}
	
	// テンプレート情報取得
	function getTemplateInfo($code)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->template.group_code ";
		$sql .= " ,$this->template.top_page_tmpl ";
		$sql .= " ,$this->template.category_page_tmpl ";
		$sql .= " ,$this->template.news_detail_tmpl ";
		$sql .= " ,$this->template.rss1_tmpl ";
		$sql .= " ,$this->template.rss2_tmpl ";
		$sql .= " ,$this->template.atom_tmpl ";
		$sql .= " ,$this->template.base_css_tmpl ";
		$sql .= " ,$this->template.bitcube_css_tmpl ";
		$sql .= " ,$this->template.bitcube_ie5win_tmpl ";
		$sql .= " from ";
		$sql .= " $this->template ";
		$sql .= " where $this->template.is_delete = 0 and $this->template.group_code = $code ";
		
		return $this->GetRow($sql);
	}
	
	// テンプレート情報追加
	function insTemplate($record)
	{
		$record["is_delete"] = 0;
		return $this->ExecuteInsert($this->template,$record);
	}
	
	// テンプレート情報編集
	function updTemplate($record,$code)
	{
		return $this->ExecuteUpdate($this->template,$record,"group_code = ".$code);
	}
	
	// テーブルをロック
	function Lock()
	{
		$this->doLock($this->template);
	}
}
