<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		CheckDirectory.class.php
 * @brief		ディレクトリチェッククラス
 * @date		2007.03.01
 */

require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/EntryManager.class.php");

class CheckDirectory
{
	function CheckDirectory()
	{
		// キャッシュディレクトリ
		if(!is_dir(CACHE_DIR))
			mkdir(CACHE_DIR);
		
		if($handle = fopen(CACHE_DIR."/.htaccess","w"))
			fwrite($handle,"deny from all");
		fclose($handle);
		
		// データディレクトリ
		if(!is_dir(DATA_DIR))
			mkdir(DATA_DIR);
		
		$group_dao = new GroupManager();
		$group_array = $group_dao->getGroupCodeList();
		foreach($group_array as $group)
		{
			if(!is_dir(DATA_DIR."/".$group["group_code"]))
				mkdir(DATA_DIR."/".$group["group_code"]);
			
			$entry_dao = new EntryManager();
			$entry_array = $entry_dao->getEntryCodeList("","$entry_dao->entry.group_code = ".$group["group_code"]);
			foreach($entry_array as $entry)
				if(!is_dir(DATA_DIR."/".$group["group_code"]."/".$entry["entry_code"]))
					mkdir(DATA_DIR."/".$group["group_code"]."/".$entry["entry_code"]);
		}
		
		// ロックディレクトリ
		if(!is_dir(LOCK_DIR))
			mkdir(LOCK_DIR);
		
		if($handle = opendir(LOCK_DIR))
			while(false !== ($file = readdir($handle)))
				if(($file != ".") && ($file != ".."))
					if((time() - filemtime(LOCK_DIR."/".$file)) > ENTRY_RESERVE_TIME)
						$this->UnlockResaveEntry($file);
		closedir($handle);
		
		// ログディレクトリ
		if(!is_dir(LOG_DIR))
			mkdir(LOG_DIR);
	}
	
	function UnlockResaveEntry($entry_code)
	{
		system("rm -r \"".LOCK_DIR."/".$entry_code."\" ");
		
		$group_dao = new GroupManager();
		$group_array = $group_dao->getGroupCodeList();
		foreach($group_array as $group)
			if($group["group_code"] > 0)
				system("rm -r \"".DATA_DIR."/".$group["group_code"]."/".$entry_code."\" ");
	}
}
