<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		LoginForm.class.php
 * @brief		ログインフォームクラス
 * @date		2007.01.17
 */

require_once(CLASS_DIR."/form/AbstractForm.class.php");

class LoginForm extends AbstractForm
{
	function setUserName($user_name="")
	{
		$this->user_name = $user_name;
	}
	
	function setUserPass($user_pass="")
	{
		$this->user_pass = $user_pass;
	}
	
	function check()
	{
		$error_array = array();
		if(!is_null($this->user_name))
			if(!strlen($this->user_name))
				$error_array["user_name"] = "ユーザ名を入力してください。";
		if(!is_null($this->user_pass))
			if(!strlen($this->user_pass))
				$error_array["user_pass"] = "パスワードを入力してください。";
		return $error_array;
	}
}
