<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		SmartyHelper.class.php
 * @brief		
 * @date		2006.05.23
 */

require_once(LIBRARY_DIR."/smarty/Smarty.class.php");

class SmartyHelper extends Smarty
{
	// コンストラクタ
	function SmartyHelper()
	{
		// スーパークラスのコンストラクタ呼び出し
		$this->Smarty();
		
		// デバッグ設定
		$this->debugging = (isset($GLOBALS["smtdebug"])) ? true : false;
		
		// デリミタ設定
		$this->left_delimiter  = "<[";
		$this->right_delimiter = "]>";
		
		// プロパティ設定
		$this->template_dir  = TEMPLATE_DIR."/";
		$this->config_dir    = TEMPLATE_DIR."/";
		$this->compile_dir   = CACHE_DIR."/";
		$this->templatec_dir = CACHE_DIR."/";
		$this->cache_dir     = CACHE_DIR."/";
		$plugins = array(
			LIBRARY_DIR."/smarty/plugins",
			PLUGIN_DIR."/smarty"
		);
		$this->plugins_dir   = $plugins;
		$this->caching       = false;
	}
}

// リソースプラグイン関数
function get_smarty_template($tpl_name,&$tpl_source,&$smarty)
{
	$tpl_source = $tpl_name;
	return true;
}

function get_smarty_timestamp($tpl_name,&$tpl_timestamp,&$smarty)
{
	$tpl_timestamp = time();
	return true;
}

function get_smarty_secure($tpl_name,&$smarty)
{
	return true;
}

function get_smarty_trusted($tpl_name,&$smarty)
{
	
}
