<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty {tinymce} plugin
 *
 * Type:     function
 * Name:     tinymce
 * Purpose:  tinymce
 * @author   Yuki Yoshioka
 * @param    array
 * @param    smarty
 * @return   string(javascript + textarea)
 */
function smarty_function_tinymce($params, &$smarty)
{
	if(!isset($params['elements']) || empty($params['elements']))
	{
		$smarty->trigger_error('tinymce: required parameter "elements" missing');
	}
	
	static $base_path;
	static $base_arguments = array();
	
	if(!count($base_arguments)) $init = TRUE;
	else $init = FALSE;
	
	if(isset($params['BasePath']))
	{
		$base_path = $params['BasePath'];
	}
	else if(empty($base_arguments['BasePath']))
	{
		$base_path = '/TinyMCE/';
	}
	
	if(isset($params['elements'])) $base_arguments['elements'] = $params['elements'];
	if(isset($params['width'])) $base_arguments['width'] = $params['width'];
	if(isset($params['height'])) $base_arguments['height'] = $params['height'];
	if(isset($params['theme'])) $base_arguments['theme'] = $params['theme'];
	if(isset($params['plugins'])) $base_arguments['plugins'] = $params['plugins'];
	if(isset($params['theme_advanced_buttons1'])) $base_arguments['theme_advanced_buttons1'] = $params['theme_advanced_buttons1'];
	if(isset($params['theme_advanced_buttons2'])) $base_arguments['theme_advanced_buttons2'] = $params['theme_advanced_buttons2'];
	if(isset($params['theme_advanced_buttons3'])) $base_arguments['theme_advanced_buttons3'] = $params['theme_advanced_buttons3'];
	
	$out = '';
	
	if($init)
	{
		$out .= '<script type="text/javascript" src="'.$base_path.'tiny_mce.js"></script>';
	}
	
	$out .= "\n<script type=\"text/javascript\">\n";
	$out .= "tinyMCE.init({\n";
	$out .= "mode : \"exact\",\n";
	
	foreach($base_arguments as $key => $value)
	{
		if(!is_bool($value))
		{
			$value = '"'.preg_replace("/[\r\n]+/",'" + $0"',addslashes($value)).'"';
		}
		$out .= $key." : ".$value.",\n";
	}
	$out .= "theme_advanced_toolbar_location : \"top\",\n";
	$out .= "theme_advanced_toolbar_align : \"left\",\n";
	$out .= "theme_advanced_statusbar_location : \"bottom\",\n";
	$out .= "theme_advanced_resizing : true,\n";
	$out .= "theme_advanced_resize_horizontal : false,\n";
	$out .= "theme_advanced_layout_manager : \"SimpleLayout\",\n";
	$out .= "cleanup : true,\n";
	$out .= "language : \"ja_utf-8\"";
	$out .= "});\n";
	$out .= "</script>\n";
	$out .= "<textarea name=\"".$base_arguments['elements']."\" rows=\"20\" cols=\"100\">".htmlspecialchars($params['value'])."</textarea>\n";
	
	return $out;
}

?>