<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */

/**
 * Include the {@link shared.make_timestamp.php} plugin
 */
require_once $smarty->_get_plugin_filepath('shared','make_timestamp');
/**
 * Smarty date_format modifier plugin
 *
 * Type:     modifier<br>
 * Name:     date_format<br>
 * Purpose:  format datestamps via strftime<br>
 * Input:<br>
 *         - string: input date string
 *         - format: strftime format for output
 *         - default_date: default date if $string is empty
 * @link http://smarty.php.net/manual/en/language.modifier.date.format.php
 *          date_format (Smarty online manual)
 * @author   Monte Ohrt <monte at ohrt dot com>
 * @param string
 * @param string
 * @param string
 * @return string|void
 * @uses smarty_make_timestamp()
 */
function smarty_modifier_sectohour($sec,$format_hour="%02dh",$format_min="%02dm",$format_sec="%02ds")
{
    if($sec != "")
    {
		$hour = floor($sec / 3600);
		$sec %= 3600;
		$min = floor($sec / 60);
		$sec %= 60;
		
		$rtn = "";
		
		if($hour > 0)
			$rtn .= sprintf($format_hour,$hour);
		
		if($min > 0)
			$rtn .= sprintf($format_min,$min);
		
		if($sec > 0)
			$rtn .= sprintf($format_sec,$sec);
        
        return $rtn;
    }
    else
    {
        return;
    }
}

/* vim: set expandtab: */

?>
