<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		BitcubeDB.class.php
 * @brief		bitcubeデータベース操作クラス
 * @date		2007.01.19
 */

require_once(CLASS_DIR."/adodb/AbstractDB.class.php");

class BitcubeDB extends AbstractDB
{
	function BitcubeDB()
	{
		$debug = (isset($GLOBALS["adodebug"])) ? true : false;
		$this->AbstractDB($debug);
		
		$this->account = $this->prefix("account");
		$this->group = $this->prefix("group");
		$this->category = $this->prefix("category");
		$this->entry = $this->prefix("entry");
		$this->template = $this->prefix("template");
		$this->template_module = $this->prefix("template_module");
	}
	
	// テーブル名をプレフィックス
	function prefix($table)
	{
		return DB_PREFIX."_".$table;
	}
	
	// 全てのテーブルをロック
	function LockALL()
	{
		$this->doLock($this->account);
		$this->doLock($this->group);
		$this->doLock($this->category);
		$this->doLock($this->entry);
		$this->doLock($this->template);
		$this->doLock($this->template_module);
	}
}
