<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		EntryManager.class.php
 * @brief		entryテーブルの処理を行うクラス
 * @date		2007.01.19
 */

require_once(CLASS_DIR."/adodb/BitcubeDB.class.php");

class EntryManager extends BitcubeDB
{
	function EntryManager()
	{
		$this->BitcubeDB();
	}
	
	// 記事情報取得
	function getEntryInfo($code)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->entry.entry_code ";
		$sql .= " ,$this->entry.group_code ";
		$sql .= " ,$this->entry.category_code ";
		$sql .= " ,$this->category.category_name ";
		$sql .= " ,$this->entry.entry_regist_date ";
		$sql .= " ,$this->entry.entry_modification_date ";
		$sql .= " ,$this->entry.entry_date ";
		$sql .= " ,$this->entry.entry_publish ";
		$sql .= " ,$this->entry.entry_title ";
		$sql .= " ,$this->entry.entry_body ";
		$sql .= " ,$this->entry.entry_order ";
		$sql .= " from ";
		$sql .= " $this->entry left outer join $this->category on $this->category.category_code = $this->entry.category_code ";
		$sql .= " where $this->entry.is_delete = 0 and $this->entry.entry_code = $code";
		
		return $this->GetRow($sql);
	}
	
	// RSSに出力する記事情報一覧取得
	function getRSSList($group_code)
	{
		$group_rss_output_num = $this->GetOne("select $this->group.group_rss_output_num from $this->group where $this->group.group_code = $group_code");
		
		// SQL文
		$sql  = " select ";
		$sql .= " $this->group.group_code ";
		$sql .= " ,$this->group.group_dir_name ";
		$sql .= " ,$this->group.group_summary_strings_num ";
		$sql .= " ,$this->entry.entry_code ";
		$sql .= " ,$this->entry.entry_date ";
		$sql .= " ,$this->entry.entry_title ";
		$sql .= " ,$this->entry.entry_body ";
		$sql .= " ,$this->category.category_name ";
		$sql .= " from ";
		$sql .= " $this->entry left outer join $this->group on $this->group.is_delete = 0 and $this->group.group_code = $this->entry.group_code ";
		$sql .= " left outer join $this->category on $this->category.is_delete = 0 and $this->category.category_code = $this->entry.category_code ";
		
		// 条件文
		$condition  = " where $this->entry.is_delete = 0 ";
		$condition .= " and $this->entry.entry_publish = 1 ";
		$condition .= " and $this->entry.group_code = $group_code";
		
		$orderby = " order by $this->entry.entry_order desc ";
		
		$sql .= $condition.$orderby;
		
		return $this->SelectLimit($sql,$group_rss_output_num,0);
	}
	
	// 記事情報一覧取得
	function getEntryList($orderby="",$condition="",$nrows="",$page="")
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->entry.entry_code ";
		$sql .= " ,$this->entry.group_code ";
		$sql .= " ,$this->entry.entry_date ";
		$sql .= " ,$this->entry.entry_publish ";
		$sql .= " ,$this->entry.entry_title ";
		$sql .= " ,$this->entry.entry_body ";
		$sql .= " ,$this->entry.entry_order ";
		$sql .= " ,$this->entry.entry_page_view ";
		$sql .= " from ";
		$sql .= " $this->entry ";
		
		// 条件文
		$condition = ($condition) ?
			" where $this->entry.is_delete = 0 and $condition ":
			" where $this->entry.is_delete = 0 ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		return $this->PageExecute($sql,$nrows,$page);
	}
	
	// 記事コード一覧取得
	function getEntryCodeList($orderby="",$condition="",$offset=-1,$limit=-1)
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->entry.entry_code ";
		$sql .= " from ";
		$sql .= " $this->entry ";
		
		// 条件文
		if($condition)
			$condition = " where $condition ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		$rs = $this->SelectLimit($sql,$limit,$offset);
		
		return $rs->GetArray();
	}
	
	// オーダー前後記事コード取得
	function getNextPrevEntry($code,$orderby="",$condition="")
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->entry.entry_code ";
		$sql .= " ,$this->entry.entry_order ";
		$sql .= " from ";
		$sql .= " $this->entry ";
		
		// 条件文
		$condition = ($condition) ?
			" where $this->entry.is_delete = 0 and $condition ":
			" where $this->entry.is_delete = 0 ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		$rs = $this->Execute($sql);
		
		if($rs->RecordCount() > 0)
		{
			while(!$rs->EOF)
			{
				$fields = $rs->fields;
				if($fields["entry_code"] == $code)
				{
					$rs->MoveNext();
					if(!$rs->EOF)
					{
						$result["bottom"] = $rs->fields["entry_code"];
					}
					break;
				}
				$result["top"] = $fields["entry_code"];
				$rs->MoveNext();
			}
		}
		return $result;
	}
	
	// 削除された記事情報一覧取得
	function getEntryTrashList($orderby="",$condition="",$nrows="",$page="")
	{
		// SQL文
		$sql  = " select ";
		$sql .= " $this->entry.entry_code ";
		$sql .= " ,$this->entry.group_code ";
		$sql .= " ,$this->group.group_name ";
		$sql .= " ,$this->entry.category_code ";
		$sql .= " ,$this->category.category_name ";
		$sql .= " ,$this->entry.entry_modification_date ";
		$sql .= " ,$this->entry.entry_title ";
		$sql .= " from ";
		$sql .= " ($this->entry left outer join $this->group on $this->group.group_code = $this->entry.group_code) left outer join $this->category on $this->category.category_code = $this->entry.category_code ";
		
		// 条件文
		$condition = ($condition) ?
			" where $this->entry.is_delete = 1 and $condition ":
			" where $this->entry.is_delete = 1 ";
		
		if($orderby)
			$orderby = " order by $orderby ";
		
		$sql .= $condition.$orderby;
		
		return $this->PageExecute($sql,$nrows,$page);
	}
	
	// 記事情報追加
	function insEntry($record)
	{
		$record["entry_regist_date"] = str_replace("'","",$this->DBTimeStamp());
		$record["entry_modification_date"] = str_replace("'","",$this->DBTimeStamp());
		$record["entry_order"] = $this->getNextEntryOrder($record["group_code"]);
		$record["entry_page_view"] = 0;
		$record["is_delete"] = 0;
		
		return $this->ExecuteInsert($this->entry,$record);
	}
	
	// 記事情報編集
	function updEntry($record,$code)
	{
		$record["entry_modification_date"] = str_replace("'","",$this->DBTimeStamp());
		return $this->ExecuteUpdate($this->entry,$record,"entry_code = ".$code);
	}
	
	// 記事情報オーダー入れ替え
	function cngEntryOrder($current_code,$target_code)
	{
		$current_order = $this->GetOne("select $this->entry.entry_order from $this->entry where $this->entry.entry_code = ".$current_code);
		$target_order = $this->GetOne("select $this->entry.entry_order from $this->entry where $this->entry.entry_code = ".$target_code);
		$record["entry_order"] = $target_order;
		$rtn = $this->ExecuteUpdate($this->entry,$record,"entry_code = ".$current_code);
		$record["entry_order"] = $current_order;
		$rtn = $this->ExecuteUpdate($this->entry,$record,"entry_code = ".$target_code);
		
		return $rtn;
	}
	
	// 記事情報削除
	function delEntry($code)
	{
		$record["is_delete"] = 1;
		return $this->ExecuteUpdate($this->entry,$record,"entry_code = ".$code);
	}
	
	// 記事情報復旧
	function rtnEntry($code)
	{
		$record["is_delete"] = 0;
		if(!$this->ExecuteUpdate($this->group,$record,"group_code = (select group_code from $this->entry where entry_code = ".$code.")"))
			return false;
		if(!$this->ExecuteUpdate($this->template,$record,"group_code = (select group_code from $this->entry where entry_code = ".$code.")"))
			return false;
		if(!$this->ExecuteUpdate($this->category,$record,"category_code = (select category_code from $this->entry where entry_code = ".$code.")"))
			return false;
		$record["entry_publish"] = 0;
		return $this->ExecuteUpdate($this->entry,$record,"entry_code = ".$code);
	}
	
	// 記事情報完全削除
	function delRealEntry($code)
	{
		return $this->ExecuteDelete($this->entry,"entry_code = ".$code);
	}
	
	// 記事情報掲載
	function pubEntry($code)
	{
		$record["entry_publish"] = 1;
		return $this->ExecuteUpdate($this->entry,$record,"entry_code = ".$code);
	}
	
	// 記事情報非掲載
	function npubEntry($code)
	{
		$record["entry_publish"] = 0;
		return $this->ExecuteUpdate($this->entry,$record,"entry_code = ".$code);
	}
	
	// 最新コードを取得
	function getLastEntryCode()
	{
		return $this->GetMax($this->entry,"entry_code");
	}
	
	// 新規追加されるコードを取得
	function getNextEntryCode()
	{
		return $this->getLastEntryCode() + 1;
	}
	
	// 最新オーダーコードを取得
	function getLastEntryOrder($condition="")
	{
		return $this->GetMax($this->entry,"entry_order","group_code = ".$condition);
	}
	
	// 新規追加されるオーダーコードを取得
	function getNextEntryOrder($condition="")
	{
		return $this->getLastEntryOrder($condition) + 1;
	}
	
	// 件数を取得
	function getEntryCount($condition)
	{
		$condition = ($condition) ?
			" $this->entry.is_delete = 0 and ".$condition." ":
			" $this->entry.is_delete = 0 ";
		return $this->GetCount($this->entry,$condition);
	}
	
	// 削除された件数を取得
	function getEntryTrashCount($condition)
	{
		$condition = ($condition) ?
			" $this->entry.is_delete = 1 and ".$condition." ":
			" $this->entry.is_delete = 1 ";
		return $this->GetCount($this->entry,$condition);
	}
	
	// テーブルをロック
	function Lock()
	{
		$this->doLock($this->entry);
	}
}
