<?php
/*
 *
 * $RCSfile: blackboard.php,v $
 * $Date: 2005/06/19 12:36:06 $
 * $Author: die $
 * 
 * Ф󥵡¦ץ
 * 
 * Copyright (c) 2005 die kato
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
	// եɤ߹
	require('blackboard.ini.default');
	// եɤ߹
	if (file_exists('blackboard.ini')) {
		require('blackboard.ini');
	}

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		// ݡɽ
		if (isset($_GET['report'])) {
			require('report.inc');

		// Фɽ
		} else {
			require('blackboard.html.inc');
		}

	// 
	} else if (isset($_POST['erase'])) {
		init_image();
		get_self();

	// ΡȤˤȤ
	} else if (isset($_POST['t'])) {
		take_note($_POST['t']);
		get_self();

	} else {
		// Ф
		if (isset($_POST['s'])) {
			$im = create_image();
			interpret($im, $_POST['s']);
			save_image($im, get_blackboard_image_name());
		}
		header('content-type: text/plain');
		echo "ok";
	}

	/*
	 * 롣
	 */
	function init_image() {
		global $blackboard_width, $blackboard_height;
		$im = imagecreate($blackboard_width, $blackboard_height);
		imagecolortransparent($im, imagecolorallocate($im, 255, 255, 255));
		save_image($im, get_blackboard_image_name());
	}

	/*
	 * ᡼֥Ȥ롣
	 */
	function create_image() {
		$fname = get_blackboard_image_name();
		//if (!file_exists($fname) || exif_imagetype($fname) != IMAGETYPE_PNG) {
		if (!file_exists($fname)) {
			init_image();
		}
		return imagecreatefrompng($fname);
	}

	/*
	 * ᡼¸롣
	 * $im: ᡼
	 * $fnale: ե̾
	 */
	function save_image($im, $fname) {
		imagepng($im, $fname);
	}

	/*
	 * 褹롣
	 * $im: ᡼
	 * $operands: 
	 * $pen_color: ڥο
	 */
	function draw_line($im, $operands, $pen_color) {
		$px = $operands[0];
		$py = $operands[1];
		$size = count($operands);
		$i = ($size > 2) ?  2 : 0;
		while ($i < $size - 1) {
			imageline($im, $px, $py, $operands[$i], $operands[$i+1], $pen_color);
			$px = $operands[$i];
			$py = $operands[$i+1];
			$i += 2;
		}
	}

	/*
	 * ץȤ᤹롣
	 * $im: ᡼
	 * $script: ץ
	 */
	function interpret($im, $script) {
		$program = split(' ', $script);
		$operands = array();
		// ߤϥڥοϰ쿧
		$pen_color = imagecolorallocate($im, 0xcc, 0xcc, 0xcc);
		foreach ($program as $op) {
			// ޤΤȤڥ졼ϥ饤lפ
			if ($op == "l") {
				draw_line($im, $operands, $pen_color);
				$operands = array();
			// ¾Ϥߤʿ
			} else {
				array_push($operands, $op);
			}
		}
	}

	/*
	 * ФƤΡȤˤĤ
	 * $title: ȥʸ
	 */
	function take_note($title) {
		global $page_title_max_length;
		// ȥʸ̵
		$title = htmlspecialchars($title);
		$title = strtr($title, "\n", " ");
		$title = strtr($title, "\r", " ");
		$len = mb_strlen($title);
		if ($len > $page_title_max_length || $len == 0) {
			return;
		}
		$im = create_image();
		// ĤȥΡȤǤطʤ㤦ᡢȿž
		for ($i = 0; $i < imagecolorstotal($im); $i++) {
			$a = imagecolorsforindex($im, $i);
			imagecolorset($im, $i, 0xff-$a['red'], 0xff-$a['green'], 0xff-$a['blue']);
		}
		$t = time();
		save_image($im, get_page_image_name($t));
		$f = fopen(get_note_index_name(), 'a');
		fputs($f, "" . $t . " " . $title . "\n");
		fclose($f);
	}

	/*
	 * 2ɻ
	 * ʬȤФgetꥯȤȯԤޤ
	 */
	function get_self() {
		header('HTTP/1.1 303 See Other');
		header("Location: " . get_script_uri());
	}

	/*
	 * ץȤURI
	 */
	function get_script_uri() {
		return get_server() . $_SERVER['PHP_SELF'];
	}

	/*
	 * Ф
	 */
	function get_server() {
		$to = ($_SERVER['SERVER_PORT'] == 443 ? 'https://' : 'http://');
		$to .= $_SERVER['SERVER_NAME'];
		$to .= ($_SERVER['SERVER_PORT'] == 80 ? '' : ':' . $_SERVER['SERVER_PORT']);
		return $to;
	}

	/*
	 * Ф̾μ
	 */
	function get_blackboard_image_name() {
		global $data_dir, $blackboard_image;
		return $data_dir . $blackboard_image;
	}

	/*
	 * Ρܼե̾μ
	 */
	function get_note_index_name() {
		global $data_dir, $note_index;
		return $data_dir . $note_index;
	}

	/*
	 * ڡ̾μ
	 * $time: 
	 */
	function get_page_image_name($time) {
		global $data_dir, $page_image_prefix, $page_image_suffix;
		return $data_dir . $page_image_prefix . $time . $page_image_suffix;
	}

	function get_page_image_uri($time) {
		return get_server() . dirname($_SERVER['PHP_SELF']) . '/' . get_page_image_name($time);
	}

	/*
	 * ڡURI
	 * $time: 
	 */
    function get_page_uri($date, $script_uri) {
        return ($script_uri == "" ? get_script_uri() : $script_uri . '?page=' . $date . '#note');
    }
?>
