/*
 * Decompiled with CFR 0.152.
 */
package blanco.commons.calc.parser;

import blanco.commons.parser.ContentHandlerStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractBlancoCalcParser
implements XMLReader {
    private ContentHandler contentHandler = null;
    private ContentHandlerStream chainedContentHandler = null;
    public static final String URI_PROPERTY_NAME_WORKBOOK = "http://blanco/commons/calc/parser/workbook";
    public static final String URI_PROPERTY_NAME_SHEET = "http://blanco/commons/calc/parser/sheet";
    private String _propertyNameWorkbook = "workbook";
    private String _propertyNameSheet = "sheet";

    public final boolean getFeature(String arg0) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public final void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public final Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(URI_PROPERTY_NAME_WORKBOOK)) {
            return this._propertyNameWorkbook;
        }
        if (name.equals(URI_PROPERTY_NAME_SHEET)) {
            return this._propertyNameSheet;
        }
        throw new SAXNotRecognizedException("\u3053\u306e\u540d\u79f0\u306f\u30cf\u30f3\u30c9\u30ea\u30f3\u30b0\u3067\u304d\u307e\u305b\u3093." + name);
    }

    public final void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(URI_PROPERTY_NAME_WORKBOOK)) {
            this._propertyNameWorkbook = (String)value;
        } else if (name.equals(URI_PROPERTY_NAME_SHEET)) {
            this._propertyNameSheet = (String)value;
        } else {
            throw new SAXNotRecognizedException("\u3053\u306e\u540d\u79f0\u306f\u30cf\u30f3\u30c9\u30ea\u30f3\u30b0\u3067\u304d\u307e\u305b\u3093." + name);
        }
    }

    public final void setEntityResolver(EntityResolver arg0) {
    }

    public final EntityResolver getEntityResolver() {
        return null;
    }

    public final void setDTDHandler(DTDHandler arg0) {
    }

    public final DTDHandler getDTDHandler() {
        return null;
    }

    public final void setContentHandler(ContentHandler arg0) {
        this.contentHandler = arg0;
        if (this.chainedContentHandler != null) {
            this.chainedContentHandler.setContentHandler(arg0);
        }
    }

    public final ContentHandler getContentHandler() {
        if (this.chainedContentHandler == null) {
            return this.contentHandler;
        }
        return this.chainedContentHandler;
    }

    public final void chainContentHandlerStream(ContentHandlerStream arg0) {
        this.chainedContentHandler = arg0;
    }

    public final void setErrorHandler(ErrorHandler arg0) {
    }

    public final ErrorHandler getErrorHandler() {
        return null;
    }

    public final void parse(InputSource inputSource) throws IOException, SAXException {
        Workbook workbook;
        block7: {
            workbook = null;
            try {
                if (inputSource.getByteStream() != null) {
                    workbook = Workbook.getWorkbook((InputStream)inputSource.getByteStream());
                    break block7;
                }
                if (inputSource.getSystemId() != null && inputSource.getSystemId().length() > 0) {
                    workbook = Workbook.getWorkbook((File)new File(inputSource.getSystemId()));
                    break block7;
                }
                throw new IOException("\u6307\u5b9a\u3055\u308c\u305fInputSource\u306f\u51e6\u7406\u3067\u304d\u307e\u305b\u3093.");
            }
            catch (BiffException e) {
                e.printStackTrace();
                throw new IOException("\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f.: " + e.toString());
            }
        }
        this.parseWorkbook(workbook);
        if (workbook != null) {
            workbook.close();
        }
        if (inputSource.getByteStream() != null) {
            inputSource.getByteStream().close();
        }
        if (inputSource.getCharacterStream() != null) {
            inputSource.getCharacterStream().close();
        }
    }

    public final void parse(String arg0) throws IOException, SAXException {
        InputSource inputSource = new InputSource(arg0);
        inputSource.setByteStream(new FileInputStream(arg0));
        this.parse(inputSource);
    }

    private void parseWorkbook(Workbook workbook) throws SAXException {
        this.getContentHandler().startDocument();
        this.getContentHandler().startElement("", (String)this.getProperty(URI_PROPERTY_NAME_WORKBOOK), (String)this.getProperty(URI_PROPERTY_NAME_WORKBOOK), new AttributesImpl());
        for (int indexSheet = 0; indexSheet < workbook.getNumberOfSheets(); ++indexSheet) {
            Sheet sheet = workbook.getSheet(indexSheet);
            this.parseSheet(sheet);
        }
        this.getContentHandler().endElement("", (String)this.getProperty(URI_PROPERTY_NAME_WORKBOOK), (String)this.getProperty(URI_PROPERTY_NAME_WORKBOOK));
        this.getContentHandler().endDocument();
    }

    private final void parseSheet(Sheet sheet) throws SAXException {
        AttributesImpl attrImpl = new AttributesImpl();
        attrImpl.addAttribute("", "name", "name", "CDATA", sheet.getName());
        this.getContentHandler().startElement("", (String)this.getProperty(URI_PROPERTY_NAME_SHEET), (String)this.getProperty(URI_PROPERTY_NAME_SHEET), attrImpl);
        this.startSheet(sheet.getName());
        int maxRows = sheet.getRows();
        for (int row = 0; row < maxRows; ++row) {
            this.startRow(row + 1);
            Cell[] cells = sheet.getRow(row);
            for (int column = 0; column < cells.length; ++column) {
                this.startColumn(column + 1);
                String value = cells[column].getContents();
                this.fireCell(column + 1, row + 1, value);
                this.endColumn(column + 1);
            }
            this.endRow(row + 1);
        }
        this.endSheet(sheet);
        this.getContentHandler().endElement("", (String)this.getProperty(URI_PROPERTY_NAME_SHEET), (String)this.getProperty(URI_PROPERTY_NAME_SHEET));
    }

    protected abstract void startSheet(String var1) throws SAXException;

    protected abstract void endSheet(Sheet var1) throws SAXException;

    protected abstract void startRow(int var1) throws SAXException;

    protected abstract void endRow(int var1) throws SAXException;

    protected abstract void startColumn(int var1) throws SAXException;

    protected abstract void endColumn(int var1) throws SAXException;

    protected abstract void fireCell(int var1, int var2, String var3) throws SAXException;

    public static final Transformer getTransformer() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        return transformer;
    }
}

