/*
 * Decompiled with CFR 0.152.
 */
package blanco.commons.calc.parser;

import blanco.commons.calc.parser.AbstractBlancoCalcParser;
import blanco.commons.calc.parser.block.AbstractBlancoCalcParserBlock;
import blanco.commons.calc.parser.block.BlancoCalcParserPropertyBlock;
import blanco.commons.calc.parser.block.BlancoCalcParserPropertyKey;
import blanco.commons.calc.parser.block.BlancoCalcParserTableBlock;
import blanco.commons.calc.parser.block.BlancoCalcParserTableColumn;
import blanco.commons.calc.parser.block.BlancoCalcParserValueMapping;
import java.util.ArrayList;
import jxl.Sheet;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BlancoCalcParser
extends AbstractBlancoCalcParser {
    public static final boolean IS_DEBUG = false;
    private ArrayList listBlock = new ArrayList();
    private AbstractBlancoCalcParserBlock currentBlock = null;
    private BlancoCalcParserPropertyKey currentKeyMapItem = null;
    private int waitForValueX = -1;
    private int waitForValueY = -1;
    private int waitForIteratorTitleSearchY = -1;
    private boolean isNoCellExistOnRow = true;
    private boolean isFirstIteratorRowItem = true;

    public void add(AbstractBlancoCalcParserBlock block) {
        this.listBlock.add(block);
    }

    protected void startSheet(String sheetName) throws SAXException {
    }

    protected void endSheet(Sheet sheet) throws SAXException {
        if (this.currentBlock != null) {
            this.getContentHandler().endElement("", this.currentBlock.getName(), this.currentBlock.getName());
            this.currentBlock = null;
        }
        this.waitForValueX = -1;
        this.waitForValueY = -1;
        this.waitForIteratorTitleSearchY = -1;
        this.currentKeyMapItem = null;
    }

    protected void startRow(int row) throws SAXException {
        this.isNoCellExistOnRow = true;
        this.isFirstIteratorRowItem = true;
    }

    protected void endRow(int row) throws SAXException {
        BlancoCalcParserTableBlock blockLook;
        this.waitForValueX = -1;
        if (this.waitForIteratorTitleSearchY >= 0) {
            --this.waitForIteratorTitleSearchY;
        }
        if (this.currentBlock instanceof BlancoCalcParserTableBlock && !this.isFirstIteratorRowItem && (blockLook = (BlancoCalcParserTableBlock)this.currentBlock).getRowName().length() > 0) {
            this.getContentHandler().endElement("", blockLook.getRowName(), blockLook.getRowName());
        }
        if (this.isNoCellExistOnRow) {
            if (this.waitForValueY >= 0) {
                --this.waitForValueY;
            }
            if (this.waitForValueY <= 0 && this.currentBlock != null) {
                this.getContentHandler().endElement("", this.currentBlock.getName(), this.currentBlock.getName());
                this.currentBlock = null;
            }
        }
        if (this.currentBlock == null) {
            return;
        }
        if (this.currentBlock instanceof BlancoCalcParserPropertyBlock) {
            this.currentKeyMapItem = null;
        }
    }

    protected void startColumn(int column) throws SAXException {
    }

    protected void endColumn(int column) throws SAXException {
        if (this.waitForValueX >= 0) {
            --this.waitForValueX;
        }
        if (this.currentBlock == null) {
            return;
        }
        if (this.waitForValueX < 0 && this.currentBlock instanceof BlancoCalcParserPropertyBlock) {
            this.currentKeyMapItem = null;
        }
    }

    protected void fireCell(int column, int row, String cellValue) throws SAXException {
        BlancoCalcParserTableBlock block;
        BlancoCalcParserTableColumn item;
        if (cellValue.length() == 0) {
            return;
        }
        this.isNoCellExistOnRow = false;
        if (this.currentBlock != null && this.currentBlock.isEndString(cellValue)) {
            this.getContentHandler().endElement("", this.currentBlock.getName(), this.currentBlock.getName());
            this.currentBlock = null;
        }
        if (this.currentBlock != null) {
            if (this.currentBlock instanceof BlancoCalcParserPropertyBlock) {
                if (this.currentKeyMapItem != null) {
                    String value = BlancoCalcParserValueMapping.mapping(cellValue, this.currentBlock.getValueMapping());
                    this.saveNode(this.currentKeyMapItem.getName(), value);
                    return;
                }
            } else if (this.currentBlock instanceof BlancoCalcParserTableBlock && this.waitForIteratorTitleSearchY <= 0) {
                BlancoCalcParserTableBlock blockLook = (BlancoCalcParserTableBlock)this.currentBlock;
                BlancoCalcParserTableColumn item2 = blockLook.findByColumnPosition(column);
                if (item2 == null) {
                    return;
                }
                if (this.isFirstIteratorRowItem) {
                    this.isFirstIteratorRowItem = false;
                    if (blockLook.getRowName().length() > 0) {
                        this.getContentHandler().startElement("", blockLook.getRowName(), blockLook.getRowName(), new AttributesImpl());
                    }
                }
                String value = BlancoCalcParserValueMapping.mapping(cellValue, blockLook.getValueMapping());
                this.saveNode(item2.getName(), value);
                return;
            }
        }
        for (int index = 0; index < this.listBlock.size(); ++index) {
            AbstractBlancoCalcParserBlock blockItem = (AbstractBlancoCalcParserBlock)this.listBlock.get(index);
            if (!blockItem.isStartString(cellValue)) continue;
            AttributesImpl attrImpl = new AttributesImpl();
            this.getContentHandler().startElement("", blockItem.getName(), blockItem.getName(), attrImpl);
            this.currentBlock = blockItem;
            this.waitForValueY = this.currentBlock.getSearchRangeY();
            if (!(this.currentBlock instanceof BlancoCalcParserTableBlock)) continue;
            BlancoCalcParserTableBlock block2 = (BlancoCalcParserTableBlock)this.currentBlock;
            this.waitForIteratorTitleSearchY = block2.getSearchRangeForTitleY();
        }
        if (this.currentBlock == null) {
            return;
        }
        if (this.currentBlock instanceof BlancoCalcParserPropertyBlock) {
            BlancoCalcParserPropertyKey item3 = ((BlancoCalcParserPropertyBlock)this.currentBlock).findByStartString(cellValue);
            if (item3 != null) {
                this.currentKeyMapItem = item3;
                this.waitForValueX = item3.getSearchRangeX();
            }
        } else if (this.currentBlock instanceof BlancoCalcParserTableBlock && (item = (block = (BlancoCalcParserTableBlock)this.currentBlock).findByTitleString(cellValue)) != null) {
            item.setColumnPosition(column);
        }
    }

    protected void saveNode(String key, String value) throws SAXException {
        this.getContentHandler().startElement("", key, key, new AttributesImpl());
        char[] charArray = value.toCharArray();
        this.getContentHandler().characters(charArray, 0, charArray.length);
        this.getContentHandler().endElement("", key, key);
    }
}

