/*
 * Decompiled with CFR 0.152.
 */
package blanco.commons.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class Native2AsciiWriter {
    private BufferedWriter writer;

    public Native2AsciiWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void writeComment(String comment) throws IOException {
        this.writer.write("# " + comment);
        this.writer.newLine();
    }

    public void writeProperty(String key, String value) throws IOException {
        this.writer.write(Native2AsciiWriter.encodeNative2Ascii(key, true));
        this.writer.write("=");
        this.writer.write(Native2AsciiWriter.encodeNative2Ascii(value, false));
        this.writer.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String encodeNative2Ascii(String nativeString, boolean isKey) {
        StringReader reader = new StringReader(nativeString);
        StringWriter writer = new StringWriter();
        try {
            int iRead;
            boolean isFirstChar22 = true;
            while ((iRead = reader.read()) >= 0) {
                switch ((char)iRead) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': 
                    case '\\': {
                        writer.write(92);
                        writer.write((char)iRead);
                        break;
                    }
                    case ' ': {
                        if (isKey) {
                            writer.write(92);
                            writer.write(32);
                            break;
                        }
                        if (isFirstChar22) {
                            writer.write(92);
                        }
                        writer.write(32);
                        break;
                    }
                    default: {
                        if (iRead < 32 || iRead > 126) {
                            writer.write(Native2AsciiWriter.toHexString((char)iRead));
                            break;
                        }
                        writer.write((char)iRead);
                    }
                }
                isFirstChar22 = false;
            }
            writer.flush();
            String isFirstChar22 = writer.toString();
            return isFirstChar22;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static final String toHexString(char arg) {
        String strResult = Integer.toHexString(arg).toUpperCase();
        while (strResult.length() < 4) {
            strResult = "0" + strResult;
        }
        return "\\u" + strResult;
    }
}

